#ifndef SynSoc_H
#define SynSoc_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   synsoc.h
class name      :   Synchron_Socket
author          :   Andreas Rinkel

documentation   :   Synchron_Socket is derived from ToopsSocket for 
					  synchronous communication.

                    Instantiations of Synchron_Socket may only be used
                    pair-wise. The method send does not return until the 
                    receiving side has sent a confirmation. The confirmation 
                    is done by mirroring the received message.
                    
                    You may extend this class to a multiway synchronous 
                    communication. Tip: check the number of sockets connected
                    to the channel ...

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library
#include <socket.h>

// Project header
#include "msg.h"


//------------------------------------------------------------------------
class Synchron_Socket: public ToopsSocket
{
public:
    // Use constructor of the parent class 
    Synchron_Socket( const char *name, ToopsProcess *owner, 
					 ToopsChannel *channel)
                 : ToopsSocket(name, owner, channel)
    {}
    ~Synchron_Socket() { }

    // Receive message and mirror the message (as confirmation)
    ToopsMessage *receive()
    { 
        ToopsMessage *_msg;
        
        _msg = ToopsSocket::receive();
        // Send the same message back!
        ToopsSocket::send(_msg);
        
        return _msg;
    }

    // Send a message.
    // Function does not return until the message has been confirmed by the
    // receiver.
    void send (ToopsMessage *message)
    {
        ToopsMessage *_msg;
        
        ToopsSocket::send(message);
        _msg = ToopsSocket::receive();
    }
    
    // Check for messages on the channel.
    int hasMessage ()
    {
        return ToopsSocket::hasMessage();
    }
    
private:
	

};
#endif  

