
#include "toops.h"
#include "message.h"
#include "socket.h"
#include "channel.h"
#include "to_error.h"
#include "strstrea.h"
//-----------------------------------------------------------------------------
// ToopsChannelLink (declared in channel.h)
// ====================================
IMPLEMENT_CLASSINFO(ToopsChannelLink, ToopsNamedObjectLink);

void ToopsChannelLink::write(int depth, int mode) const
{
   ToopsNamedObjectLink::write(depth,mode);
}

//-----------------------------------------------------------------------------
// ToopsChannelList (declared in channel.h)
// ====================================
IMPLEMENT_CLASSINFO(ToopsChannelList, ToopsNamedObjectList);

void ToopsChannelList::write(int depth, int mode) const
{
    ToopsObjectList::write(depth,mode);
}


//-----------------------------------------------------------------------------
// ToopsChannelLink (declared in channel.h)
// ====================================
IMPLEMENT_CLASSINFO( ToopsChannel, ToopsNamedObject);
   
ToopsError ToopsChannel::fDestroyButSockets(TE_TCHANNEL_DESTROY, 
                                 ToopsError::fatal,
                                 ToopsChannel::ThisClassInfo()->name(),
                                 "destructor called, but "
                                 "connected ToopsSockets left");
// pt 9.94 'ToopsChannel::' in Zeile 34 vor 'ThisClassInfo() eingefuegt

ToopsChannel::ToopsChannel(const char* n, responsibility r) :
    ToopsNamedObject(n, r), sysLink(this)
{
    if (!channels()->isNameValid(name()))
        eName.err(name());
    c_mode = noMode;
    c_state = noConnection;
}

ToopsChannel::~ToopsChannel()
{
    c_state = destroy;
    atStateChange();
    if (c_connected.len() != 0 /*&& ToopsSimulation::state() == ToopsSimulation::running*/)
        fDestroyButSockets.err(name());
}

void ToopsChannel::remember( ToopsSocketLink* toRemember)
{

    switch(toRemember->object()->status())
    {
       case ToopsSocket::create:
           c_connected.insert(toRemember);
           break;
       case ToopsSocket::destroy:
           c_connected.remove(toRemember);
           break;
	   default:  ; //NOP   mjk 310895
    }

    // modify status and mode, if necessary
    switch(c_connected.len())
    {
        case 0:
        case 1:
            c_mode = noMode;
            c_state = noConnection;
            break;
        case 2:
            c_mode = bidirectional;
            c_state = ready;
            break;

        default:
            c_mode = broadcast;
            c_state = ready;
    }
    atStateChange();
}

void ToopsChannel::write(int depth, int _mode) const
{
    if (depth-1 >= 0)
        ToopsNamedObject::write(depth-1, _mode);

    ostrstream o;

    if (depth==0 && !_mode)
        o << DBGends << endl;

    o << ThisClassInfo()->name() << ":  status:";

    switch (status())
    {
        case noConnection:
            o << "noConnection"; break;
        case ready:
            o << "ready"; break;
        case destroy:
            o << "destroy"; break;
    }

    o << ", mode: ";

    switch (mode())
    {
        case noMode:
            o << "noMode"; break;
        case bidirectional:
            o << "bidirectional"; break;
        case broadcast:
            o << "broadcast"; break;
    }

    o << endl;

    o << c_connected.len() << " ToopsSockets connected";

    o << endl << ends;

    char *out = o.str();
    ToopsObject::DBGout(out);
    delete out;
}

