#include "toops.h"
#include "to_list.h"
#include "message.h"
#include "to_error.h"
#include "strstrea.h"

//-----------------------------------------------------------------------------
// ToopsMessageLink (declared in message.h)
// ====================================
IMPLEMENT_CLASSINFO( ToopsMessageLink, ToopsObjectLink)
void ToopsMessageLink::write(int depth, int mode) const
{
    ToopsObjectLink::write(depth, mode);
}


//-----------------------------------------------------------------------------
// ToopsMessageList (declared in message.h)
// ====================================
IMPLEMENT_CLASSINFO( ToopsMessageList, ToopsObjectList);

void ToopsMessageList::write(int depth, int mode) const
{
    ToopsObjectList::write(depth,mode);
}

//-----------------------------------------------------------------------------
// ToopsMessage (declared in message.h)
// ================================

IMPLEMENT_CLASSINFO( ToopsMessage, ToopsObjectLink)

// static members
ToopsError ToopsMessage::fOnlyWhenSimStarted(TE_TMESSAGE_SIMNOTSTARTED,
                                     ToopsError::fatal,
                                     ToopsMessage::ThisClassInfo()->name(),
                                     " call to ToopsMessage::ToopsMessage() "
                                     "before simulation started");
// pt 9.94 'ToopsMessage::' in Zeile 36 vor 'ThisClassInfo() eingefuegt

ToopsError ToopsMessage::fNoDuplicate(TE_TMESSAGE_NODUPLICATE,
                              ToopsError::fatal,
                              ToopsMessage::ThisClassInfo()->name(),
                              " ToopsMessage::duplicate() must be overridden");
// pt 9.94 'ToopsMessage::' in Zeile 43 vor 'ThisClassInfo() eingefuegt

ToopsMessage::ToopsMessage() : ToopsMessageLink(this), sysLink(this)
{
    if (ToopsSimulation::state() != ToopsSimulation::running)
        fOnlyWhenSimStarted.err();

    m_timeToReceive = 0;
    ToopsSimulation::allMessages()->insert(&sysLink);
}


ToopsMessage::~ToopsMessage()
{
    if(isLinked())
        ((ToopsMessageList*)linkedTo())->remove(this);
    ToopsSimulation::allMessages()->remove(&sysLink);
}


ToopsMessage* ToopsMessage::duplicate(void)
{
    fNoDuplicate.err();
    return 0;
}



void ToopsMessage::write(int /*depth*/, int mode) const
{
    ostrstream o;

    if (!mode )
        o << DBGends << endl;

    o << ThisClassInfo()->name() << ":  receivedAt(): " << receivedAt()
      << endl << ends;

    char *out = o.str();
    ToopsObject::DBGout(out);
    delete out;
}

