
#include "toops.h"
#include "timer.h"
#include "procunit.h"
#include "timestep.h"
#include "strstrea.h"

//-----------------------------------------------------------------------------
// ToopsTimeStep (declared in timestep.h)
// ==================================
IMPLEMENT_CLASSINFO( ToopsTimeStep, ToopsObjectLink);

void ToopsTimeStep::add( ToopsProcessLink *toAdd)
{
    // sort the process into t_processes. Sort order: the construction
    // order of the process' owner (processor).
    t_processes.reset();
    ToopsProcess *t;   //"register" removed mjk 310895
    instance_counter toAddOrder =
        ((ToopsSimulation*)(toAdd->object()->owner())) ->order();

    while (t_processes.prev(t) &&
           ((ToopsSimulation*)(t->owner()))->order() > toAddOrder);

    if (t)
        t_processes.appendhere(toAdd);
    else
        t_processes.insert(toAdd);

}

// removed keyword virtual to avoid problems with SGI C++
void ToopsTimeStep::write(int depth, int mode) 
{
    if (depth-1 >= 0)
        ToopsObjectLink::write(depth-1, mode);

    ostrstream o;

    if (depth==0 && !mode)
        o << DBGends << endl;

    o << ThisClassInfo()->name()
      << " at: " << t_time << ", type: "
      << (type() == normal ? "normal" : "timeOutIndicator")
      << "\n  contains: " << t_sockets.len() << " ToopsSockets, "
      << t_timers.len() << " ToopsTimers, "
      << t_processes.len() << " ToopsProcesses" << endl;

    if (mode)
    {
        if (t_sockets.len())
        {
            t_sockets.reset();
            o << " ToopsSockets:\n  ";
            int i = 4;
            ToopsSocket* s;
            while (t_sockets.next(s))
            {
                o << s->name() << ", ";
                if (--i == 0)
                    { o << "\n  "; i = 4; }
            }
            o << endl;
        }

        if (t_timers.len())
        {
            t_timers.reset();
            o << "\n ToopsTimers:\n  ";
            int i = 4;
            ToopsTimer* t;
            while (t_timers.next(t))
            {
                o << t->name() << ", ";
                if (--i == 0 )
                    { o << "\n  "; i = 4; }
            }
            o << endl;
        }

        if (t_processes.len())
        {
            t_processes.reset();
            o << "\n ToopsProcesses:\n  ";
            int i = 4;
            ToopsProcess* p;
            while (t_processes.next(p))
            {
                o << p->name() << ", ";
                if (--i == 0)
                    { o << "\n  "; i = 4; }
            }
            o << endl;
        }

    }

    o << ends;

    char *out = o.str();
    ToopsObject::DBGout(out);
    delete out;
}


//-----------------------------------------------------------------------------
// ToopsTimeStepList (declared in timestep.h)
// ======================================

IMPLEMENT_CLASSINFO( ToopsTimeStepList, ToopsObjectList);

// Seek the right ToopsTimeStep to insert a ToopsTimerLink,...
void ToopsTimeStepList::sortIn( ToopsTimerLink* toSort)
{
	 reset();
	 ToopsTimeStep* step; //"register" removed mjk 310895
	 simtime when = toSort->object()->alertTime();

	 while (prev(step) && step->time() > when);

	 if (step)
	 {
		  if (step->time() == when)
				step->add(toSort);
		  else
		  {
				step = new ToopsTimeStep(when, toSort);
				if (step == 0)
					 fOutOfMem.err("", "internal, ToopsTimeStep");
				appendhere(step);
		  }
    }
    else
    {
        step = new ToopsTimeStep(when, toSort);
        if (step == 0)
            fOutOfMem.err("", "internal, ToopsTimeStep");
        insert(step);
    }
}

void ToopsTimeStepList::sortIn( ToopsSocketLink* toSort)
{
	 reset();
	 ToopsTimeStep* step;  //"register" removed mjk 310895
    simtime when = toSort->object()->nextTime();

    while (prev(step) && step->time() > when);

    if (step)
    {
        if (step->time() == when)
            step->add(toSort);
        else
        {
            step = new ToopsTimeStep(when, toSort);
            if (step == 0)
                fOutOfMem.err("", "internal, ToopsTimeStep");
            appendhere(step);
        }
    }
    else
    {
        step = new ToopsTimeStep(when, toSort);
        if (step == 0)
            fOutOfMem.err("", "internal, ToopsTimeStep");
        insert(step);
    }

}


void ToopsTimeStepList::sortIn( ToopsProcessLink* toSort)
{
	 reset();
    ToopsTimeStep* step;  //"register" removed mjk 310895
	 simtime when = toSort->object()->desiredTime();

	 while (prev(step) && step->time() > when);

    if (step)
    {
        if (step->time() == when)
            step->add(toSort);
        else
        {
            step = new ToopsTimeStep(when, toSort);
            if (step == 0)
                fOutOfMem.err("", "internal, ToopsTimeStep");
            appendhere(step);
        }
    }
    else
    {
        step = new ToopsTimeStep(when, toSort);
        if (step == 0)
            fOutOfMem.err("", "internal, ToopsTimeStep");
        insert(step);
    }
}

void ToopsTimeStepList::write(int depth, int mode) const
{
    // mode > 0 -> reduced info
    ostrstream o;
    o << endl << ThisClassInfo()->name() << " debug information:  "
      << len() << " elements\n" << ends;
    char *out = o.str();
    ToopsObject::DBGout(out);
    delete out;
    if (mode)
    {
        if (len())
        {
            DBGout(" first: ");
            _first()->write(depth,1);
            if (len() > 1)
            {
               DBGout(" last: ");
               _last()->write(depth,1);
            }
        }
    }
    else
    {
        DBGout(" list contents:\n");
        ToopsObjectList::write(depth,0);
        DBGout("ToopsTimeStepList end debug information\n");
    }
}
