#include "toops.h"
#include "to_list.h"
#include "tno_list.h"
#include <string.h>
#include "strstrea.h"

//-----------------------------------------------------------------------------
// ToopsNamedObjectLink (declared in tno_list.h)
// =========================================

IMPLEMENT_CLASSINFO( ToopsNamedObjectLink, ToopsObjectLink)

void ToopsNamedObjectLink::write(int, int mode) const
{
    // Ignore depth (because this function resembles ToopsObjectLink::write()
    // totally).
    ostrstream o;
    if (mode)
        o << DBGends << endl;

    o << ThisClassInfo()->name() << ":  object: " << name()
      << ", next: " << (_next() ? ((ToopsNamedObject*)_next())->name() : " - ")
      << ", prev: " << (_prev() ? ((ToopsNamedObject*)_prev())->name() : " - ");

    o << endl << ends;
    char *c = o.str();
    DBGout(c);
    delete c;
}


//-----------------------------------------------------------------------------
// ToopsNamedObjectList (declared in tno_list.h)
// =========================================
IMPLEMENT_CLASSINFO( ToopsNamedObjectList, ToopsObjectList)

// maps simply to ToopsObjectList::write()
void ToopsNamedObjectList::write(int depth, int mode) const
{
    ToopsObjectList::write(depth, mode);
}


// Search a given name in the list, return the corresponding ToopsNamedObject,
// if found, otherwise 0.
ToopsNamedObject* ToopsNamedObjectList::_search(const char * who)
{
    reset();
    ToopsObject *t;
    while(_setnext())
    {
        if (strcmp (who, ((ToopsNamedObject*)_current())->name()) == 0)
            return (ToopsNamedObject*)t;
    }
    return 0;
}

// See tno_list.h
int ToopsNamedObjectList::isNameValid(const char* n)
{
    if ( (n == 0) || (strlen(n) == 0) || (_search(n) != 0) )
        return 0;
    else
        return 1;
}
