#include "toops.h"
#include "to_error.h"
#include "strstrea.h"
#include <assert.h>

//-----------------------------------------------------------------------------
// ToopsClassInfo
// ==========

// initialize static members:
ToopsClassInfo* ToopsClassInfo::t_firstClass = 0;
unsigned int ToopsClassInfo::t_nClassIDctr = 0;

ToopsError ToopsObject::fOutOfMem(TE_OUT_OF_MEMORY,
                          ToopsError::fatal,
                          ToopsObject::ThisClassInfo()->name(),
                          "out of memory: ");
// pt 9.94 'ToopsObject::' ergaenzt vor 'ThisClassInfo()' in Z.16



// member functions:
ToopsClassInfo::ToopsClassInfo( const char *name, ToopsClassInfo* base)
{
    t_className = name;
    t_baseClassInfo = base;
    // set the unique class ID
    t_nClassID = ++t_nClassIDctr;

    // insert this at the chain's top
    t_nextClass = t_firstClass;
    t_firstClass = this;
#if !defined(NDEBUG)
    t_DebugControl = ~((dbgreg_t)0);
#endif

}

// This private constructor is used only once for the initialisation
// of ToopsObject's member ToopsObject::classToopsObject. This is a special case
// for providing runtime information, because ToopsObject has no parent class
// and will always be the last class in the chain of all ToopsClassInfo objects.
// Defining a private default constructor is neccesary to prevent a
// compiler generated default constructor (wouldn't make any sense).
// Because a special constructor is needed for ToopsObject's ToopsClassInfo,
// why not using the default constructor for that purpose.

ToopsClassInfo::ToopsClassInfo()
{
    // sets up the initial runtime class information for class ToopsObject
    t_className = "ToopsObject";
    t_baseClassInfo = 0;
    t_nClassID = 0;
    t_firstClass = this;
    t_nextClass = 0;
#if !defined(NDEBUG)
    t_DebugControl = ~((dbgreg_t)0);
#endif
}

//-----------------------------------------------------------------------------
// ToopsObject
// =======

// static members:
ToopsClassInfo ToopsObject::classToopsObject = ToopsClassInfo();
PVFPC ToopsObject::userOutputFunction = 0;

// member functions:
ToopsClassInfo* ToopsObject::GetClassInfo(void) const
{
    return &classToopsObject;
}
// returns 1 if toCompare is a base class of this, otherwise 0.
int ToopsObject::isInheritedFrom(const ToopsObject *toCompare) const
{
    assert(toCompare != 0);
    assert(this != 0);

    if (isSameClass(toCompare))
        return 0;

    const ToopsClassInfo *thisClassInfo = GetClassInfo(); 
		  //"register" removed mjk 310895
    ToopsClassInfo *otherClassInfo = toCompare->GetClassInfo();
    while (thisClassInfo)
    {
       if(thisClassInfo == otherClassInfo)
           return 1;
       thisClassInfo = thisClassInfo->base();
    }
    return 0;
}

// Set the user defined output function for all debugging output TOOPS
// will do. Returns the old value. A value of 0 resets to default.
PVFPC ToopsObject::setOutputFunction(PVFPC newOutputFunction)
{
    PVFPC oldfunc = userOutputFunction;
    userOutputFunction = newOutputFunction;
    return oldfunc;
}

// Output unconditionally some text (via cout, except there is an user defined
// output function)
void ToopsObject::DBGout(const char* /*const*/ text)
{
    if (userOutputFunction)
        (* userOutputFunction) (text);
    else
        cout << text << flush;
}

// only for the debug version: output the given text, if the class debug
// register's flag for this special information is set. (see also the
// DBG... macros in toops.h for the use of this). This function is NOT// intended to be used directly, since it appears not in the non debug
// version of the library. Use it via the macros instead.
#if !defined(NDEBUG)
void ToopsObject::DBGout(dbgreg_t description, dbgreg_t classDebugRegister,
                     const char* const text)
{
    if (description & classDebugRegister)
        DBGout(text);
}
#endif




#if defined (TEST_TOBJECT)
IMPLEMENT_CLASSINFO(test1, ToopsObject)
test1::test1(int i)
{
    DBG_INIT()
    DBG(ThisClassInfo()->name() << " in constructor\n" ;)
    DBG(" var set to " << i << "\n")
    var = i;
    DBG_WRITE(cstr)
}

void test1::func()
{
    DBG_INIT()
    DBG(ThisClassInfo()->name() << " in func()\n")
    DBG("var = " << var << "\n")
    var++;
    DBG("var++ : var = " << var << "\n") 
    DBG_WRITE(onfunc)
}

void test1::write(void) const
{
    ostrstream o;
    o << "var = " << var;
    char * c = o.str();
    DBGout(c);
    delete c;
}

test1::~test1()
{
    DBG_INIT()
    DBG("test1 in destructor\n")
    DBG_WRITE(dstr)
}


IMPLEMENT_CLASSINFO(test2,test1)

test2::test2(int i) : test1(-i)
{
    DBG_INIT()
    DBG(ThisClassInfo()->name() << " in constructor\n" ;)
    DBG(" anotherVar set to " << i << "\n")
    anotherVar = i;
    DBG_WRITE(cstr)
}

void test2::func()
{
    DBG_INIT()
    DBG(ThisClassInfo()->name() << " in func()\n")
    DBG("anotherVar = " << anotherVar << "\n")
    anotherVar++;
    DBG("anotherVar++ : anotherVar = " << anotherVar << "\n")
    DBG_WRITE(onfunc)
}

void test2::write(void) const
{
    ostrstream o;
    o << "anotherVar = " << anotherVar;
    char * c = o.str();
    DBGout(c);
    delete c;
}

test2::~test2()
{
    DBG_INIT()
    DBG("test2 in destructor\n")
    DBG_WRITE(dstr)
}

void testdbg(void);

void testdbg(void)
{
    test1 t1(1);
    t1.func();
}

main()
{
    cout << "\n\nTest program for classes ToopsClassInfo, ToopsObject and related stuff\n\n";

    cout << "creating some instances of test1, test2\n\n";

    test1 t1_0;
    test1 t1_1(1);
    test1 t1_2(2);
    test1 t1_3(3);

    test2 t2_1(-1);
    test2 t2_2(-2);


    cout << "\nTests, --> source code \n\n";
    cout << ToopsObject::ThisClassInfo()->name() << endl;            // ToopsObject
    //cout << ToopsObject::ThisClassInfo()->base() << endl;            // 0
    cout << ToopsObject::ThisClassInfo()->nClassID() << endl << endl;// 0

    cout << t1_1.ThisClassInfo()->name() << endl;                // test1
    cout << t1_1.ThisClassInfo()->base()->name() << endl;        // ToopsObject
    cout << t1_1.ThisClassInfo()->nClassID() << endl << endl;    // 1

    cout << t1_1.GetClassInfo()->name() << endl;                // test1
    cout << t1_1.GetClassInfo()->base()->name() << endl;        // ToopsObject
    cout << t1_1.GetClassInfo()->nClassID() << endl << endl;    // 1


    ToopsObject *t = &t2_1; // note: pointer to ToopsObject!!
    ToopsClassInfo *tc = t->GetClassInfo();
    ToopsClassInfo *tc1 = t->ThisClassInfo();
    cout << tc1->name() << endl;                                 // ToopsObject
    cout << tc1->nClassID() << endl;                             // 0
    cout << tc->name() << endl;                                  // test2
    cout << tc->nClassID() << endl << endl;                      // 2

    ToopsObject *pttest1_1 = &t1_1;
    ToopsObject *pttest1_2 = &t1_2;
    ToopsObject *pttest2_1 = &t2_1;

    cout << "pttest1_1 and pttest1_2 point to instances of ";
    if (pttest1_1->isSameClass(pttest1_2))
        cout << "the same class" << endl;
    else
        cout << "different classes" << endl;                     // same

    cout << "pttest1_1 and pttest2_1 point to instances of ";
    if (pttest1_1->isSameClass(pttest2_1))
        cout << "the same class" << endl;
    else
        cout << "different classes" << endl << endl;             // different

    cout << "pttest1_1 is ";
    if (!pttest1_1->isInheritedFrom(pttest1_2))
         cout << "not ";
    cout << "inherited from pttest1_2" << endl;                  // is not

    cout << "pttest1_1 is ";
    if (!pttest1_1->isInheritedFrom(pttest2_1))
         cout << "not ";
    cout << "inherited from pttest2_1" << endl;                  // is not

    cout << "pttest2_1 is ";
    if (!pttest2_1->isInheritedFrom(pttest1_1))
         cout << "not ";
    cout << "inherited from pttest1_1" << endl;                  // is

    cout << "\n----------\n";

    DBG_DISABLE(test1,test1::cstr)  // no information on construction
    testdbg();
    cout << "----------\n";

    DBG_DISABLE(test1,test1::dstr)  // no information on construction
                                    // and destruction
    testdbg();
    cout << "----------\n";

    DBG_DISABLE(test1,test1::onfunc)  // no information at all
    testdbg();
    cout << "----------\n";


    DBG_ENABLE(test1,test1::cstr)   // information only at construction
    testdbg();
    cout << "----------\n";

    DBG_ENABLE(test1,test1::all)    // all information
    testdbg();
    cout << "----------\n";

}

#endif
