/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name:      Parallel.cpp

documentation:  Goal of this tutorial is to build a simple system of 
                communicating processes in a step-by-step manner.
                Therefore, simple simulation scenarios are built and
                extended one by one to a simulation system. In this way,
                the user should be introduced into the class library
                and get to know the TOOPS classes. Moreover, the user
                can observe how a complex system evolves from a
                simple system and how intermediate steps and mistakes
                are taken, which finally lead to the goal in the sense
                of an 'evolutionary software development'.
                 
                Tutorial tut1 describes two processes, which run 
                independently in parallel for a predefined 
                simulation time.

author:         Andreas Rinkel
version      :  1.0, 09.09.94
history      :  01.04.96  Manfred Kraess
                clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <iostream.h>
#include <strstrea.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>
#include <procunit.h>

// Project header
#include "process.h"


//------------------------------------------------------------------------
int main()
{

    simtime duration = 30;

    // create 2 CPUs (instantiations of class ToopsProcessor)
    ToopsProcessor cpu1("cpu1");
    ToopsProcessor cpu2("cpu2");

    // create 2 processes: proc_A and proc_B 
    // instantiations of class Process  
    // (Process is derived from ToopsProcess --> see process.h)
    Process       proc_A(cpu1, 1, "Process 1");
    Process       proc_B(cpu2, 1, "Process 2");

    // definition of a variable for the return value of the simulation
    ToopsSimulation::stopReason reason;

    // Start of the simulation. 
    // Upon completion of the simulation the status will be returned
    // in the variable reason.
    // ToopsSimulation will now switch between cpu1 and cpu2
    // and control the behavior of the processes proc_A and proc_B.
    reason = ToopsSimulation::start(duration);

    // Output reporting the successful completion of the simulation.
    cout << "\n Simulation tut1 completed. Return value is: ";
    cout <<  (int)reason << "\n";
    
    // Wait for user input
    // (may cause a comiler warning: "variable is set but never used")
    cout << "\n -> Press <return> to continue: ";
    char in;
    in = cin.get ();              
        
    return reason;
}

