/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   multproc.cpp
implementation
of class        :   MultipleProcess
author          :   A.Rinkel

version         :   1.0, 09.09.94
history         :   03.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <strstrea.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>

// Project header
#include "multproc.h"

//------------------------------------------------------------------------
MultipleProcess:: MultipleProcess( ToopsProcessor &processor, uint prio,
                   const char *name )
                :  ToopsProcess( processor, prio, name )
{
    // Definition of the member objects
}

//------------------------------------------------------------------------
MultipleProcess:: ~MultipleProcess()
{
    // Delete the member objects
    delete  subProcess1;
    delete  subProcess2;
    delete  subProcess3;
}

//------------------------------------------------------------------------
void MultipleProcess:: writeProcessInfo (char* text=0)
{
    cout << " Process " << name()  << " is running, "
         << "current time: " << time()  << " \n" << flush;
    if (text != 0) { 
        cout << text << " \n" << flush;
    }
}

//---------------------------------------------------------------------------
/* documentation:  This implementation is sequential, without additional
                   structuring methods such as additional member functions
                   or member objects. Nevertheless, this would be helpful
                   for longer behavior descriptions.
                   One might think of a member object scheduler.
*/
//---------------------------------------------------------------------------
void MultipleProcess:: behavior(void)
{
    while (1)     // process loop ("forever")
    {  
        writeProcessInfo();
        // execution needs no virtual time

        consumeTime( 3 );     
        // expilcit description of time

        if ( time () > 15 ) 
        {
            // create three new processes
            subProcess1 = new Process( this->owner(), 2, "Process 2a" );
            subProcess2 = new Process( this->owner(), 2, "Process 2b" );
            subProcess3 = new Process( this->owner(), 2, "Process 2c" );

            // suspend the newly created processes
            subProcess1-> suspend();
            subProcess2-> suspend();
            subProcess3-> suspend();

            // The following while()-loop builds the scheduler for this 
            // processor. Every 2 timesteps another process should
            // is set active.               
            while (1)  // "forever", i.e. until simulation time expires
            {   
                // set subProcess1 active
                subProcess1->resume();
                // wait for 2 timesteps, while subProcess1 is active
                this->setWaiting( 2 );
                // suspend subProcess1
                subProcess1->suspend();
                writeProcessInfo();

                subProcess2->resume();
                this->setWaiting( 2 );
                subProcess2->suspend();
                writeProcessInfo();                    
                
                subProcess3->resume();
                this->setWaiting( 2 );
                subProcess3->suspend();
                writeProcessInfo();
            }
        }
    }
}
