/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name:      Parallel.cpp

documentation:  Tutorial tut2 describes two processes which run
                independently, i.e. each process on a dedicated processor,
                for a predefined simulation time.
                One of the processes will create three additional processes
                at run-time. These will then be managed by the creating
                process according to the time-slice concept.
                
                Please note the following when you look at the output
                produced by this tutorial:
                Each time slice in this example is 2 timesteps, which 
                means that the operation
                   consumeTime( 5 ) 
                will take 2 1/2 time slices.
                
author:         Andreas Rinkel
version      :  1.0, 09.09.94
history      :  03.04.96  Manfred Kraess
                clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <iostream.h>
#include <strstrea.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>
#include <procunit.h>

// Project header
#include "multproc.h"

int main()
{

   simtime duration = 60;

    // create 2 CPUs
    ToopsProcessor cpu1("cpu1");
    ToopsProcessor cpu2("cpu2",1);

    // create 2 processes; proc_A and proc_B 
    // Process and MultipleProcess are derived from ToopsProcess
    // (--> see process.h and multproc.h)
    Process           proc_A (cpu1, 2, "Process 1 ");
    MultipleProcess   proc_B (cpu2, 1, "Process 2 ");

    // definition of a variable for the return value of the simulation
    ToopsSimulation::stopReason reason;

    // start of the simulation. 
    reason = ToopsSimulation::start(duration);

    // Output reporting the successful completion of the simulation.
    cout << "\n Simulation tut2 completed. Return value is: ";
    cout <<  (int)reason << "\n";
    
    // Wait for user input
    // (may cause a comiler warning: "variable is set but never used")
    cout << "\n -> Press <return> to continue: ";
    char in;
    in = cin.get ();              

    return reason;
}
