#ifndef COM_PROC_H
#define COM_PROC_H

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   comproc.h
class name      :   ComProcess
author          :   Andreas Rinkel

documentation   :   ComProcess is a child class of ToopsProcess that contains features
                    essential for inter-process communication.
                    
                    Each instantiation of class ComProcess contains a ToopsSocket.
                    These sockets are connected to a channel that is shared by all
                    instantiations of ComProcess and its child classes.
                    
                    The communication itself (sending and receiving of messages) is
                    done in two classes derived from ComProcess: Sender and Receiver.

version         :   1.0, 09.09.94
history         :   19.04.96  Manfred Kraess
                    clean-up and modification
-------------------------------------------------------------------------------------------*/


// C++ standards
#include <strstrea.h>

// TOOPS library
#include <tprocess.h>
#include <channel.h>
#include <socket.h>

// TOOPS Utilities (string class library)
#include <str.h>
// Note: str.h contains "String", a dynamic string class 
//       (written by Scott Robert Ladd).
//       It is contained in the "utility"-path of the TOOPS-Distribution. 

// project header


// Class Description  ----------------------------------------------------
class ComProcess : public ToopsProcess
{

public:

    ComProcess (ToopsProcessor *p, uint prio, const char *name)
        :ToopsProcess (p, prio, name)
    { 
        String  _name;
        
        // create a name for the socket
        _name    =  name;
        _name   += "-socket";    
        
        // generate the socket for this process
        _socket =  new ToopsSocket (_name, this, _chan);
    }  

    ~ComProcess () 
    { 
        // delete the socket that was allocated in the constructor
        delete _socket; 
    }


protected:

    // socket for the communication
    ToopsSocket *_socket;
    
    // channel that all sockets are being connected to
    // Note: A static attribute in a C++-class is shared by all instances of the
    //       class and its child classes, i.e. there is only one channel.
    //       It is allocated in file comproc.cpp.
    static ToopsChannel *_chan;   

private:
    

};

//------------------------------------------------------------------------------------------
#endif
