/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   sender.cpp
implementation
of class        :   Sender
author          :   Andreas Rinkel
version         :   1.0, 09.09.94
history         :   19.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>

// Project header
#include "sender.h"


//------------------------------------------------------------------------
void Sender::behavior ()
{   

    while (1)
    {
        // generate a message
        TextMessage *_msg = new TextMessage( "Hello" );

        // send the message
        _socket->send (_msg);
        writeProcessInfo (" Message sent");

        // You may delete the message immediately after it has been sent.
        // It is duplicated by ToopsSocket->send().
        delete _msg;
        
        // sleep
        consumeTime(2);
    }
}


//------------------------------------------------------------------------
void Sender:: writeProcessInfo (char* text)
{       
    cout << name()  << " is running, "
         << "current time: " << time()  << "\n" << flush;
    if (text != 0) {  cout << text << endl << flush; }
}

