      SUBROUTINE PBCHERK( ICONTXT, MATBLK, UPLO, TRANS, N, K, NB, ALPHA,
     $                    A, LDA, BETA, C, LDC, IAPOS, ICROW, ICCOL,
     $                    ACOMM, AWORK, CWORK, MULLEN, WORK )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     Jaeyoung Choi, Oak Ridge National Laboratory
*     Jack Dongarra, University of Tennessee and Oak Ridge National Lab.
*     David Walker,  Oak Ridge National Laboratory
*
*     .. Scalar Arguments ..
      CHARACTER*1        ACOMM, AWORK, CWORK, MATBLK, TRANS, UPLO
      INTEGER            IAPOS, ICCOL, ICONTXT, ICROW, K, LDA, LDC,
     $                   MULLEN, N, NB
      REAL                ALPHA, BETA
*     ..
*     .. Array Arguments ..
      COMPLEX             A( LDA, * ), C( LDC, * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PBCHERK is a parallel blocked version of CHERK.
*  PBCHERK  performs one of the Hermitian rank k operations
*
*     C := alpha*A*A' + beta*C,
*
*  or
*
*     C := alpha*A'*A + beta*C,
*
*  where  alpha and beta  are scalars,  C is an N-by-N Hermitian matrix
*  and  A  is an  N-by-K matrix in the first case and  a K-by-N matrix
*  in the second case.
*
*  The first elements  of the matrices A, and C  should  be  located  at
*  the beginnings of their first blocks. (not the middle of the blocks.)
*  A can be broadcast if necessary  and then transposed.  The communica-
*  tion scheme can be selected.
*
*  Parameters
*  ==========
*
*  ICONTXT (input) INTEGER
*          ICONTXT is the BLACS mechanism for partitioning communication
*          space.  A defining property of a context is that a message in
*          a context cannot be sent or received in another context.  The
*          BLACS context includes the definition of a grid, and each
*          process' coordinates in it.
*
*  MATBLK  (input) CHARACTER*1
*          MATBLK specifies whether C is a (full) block matrix or
*          a single block as follows:
*
*             MATBLK = 'M',  C is a (full) block matrix,
*             MATBLK = 'B',  C is a single block.
*
*  UPLO    (input) CHARACTER*1
*          UPLO specifies whether the upper or lower triangular part of
*          the array C is to be referenced as follows:
*
*             UPLO = 'U',  Only the  upper triangular part of  C
*                          is to be referenced.
*             UPLO = 'L',  Only the  lower triangular part of  C
*                          is to be referenced.
*
*  TRANS   (input) CHARACTER*1
*          TRANS specifies the operation to be performed as follows:
*
*             TRANS = 'N',   C := alpha*A*A' + beta*C.
*             TRANS = 'C',   C := alpha*A'*A + beta*C.
*
*  N       (input) INTEGER
*          N specifies the order of the matrix C.  N >= 0.
*
*  K       (input) INTEGER
*          If TRANS = 'N',  K specifies  the number of  columns of  the
*          matrix A, and if TRANS = 'C', K specifies the number of rows
*          of the matrix A.  K >= 0.
*
*  NB      (input) INTEGER
*          NB specifies the row and column block size of the matrix C.
*          It also specifies the row block size of the matrix A if
*          MATBLK = 'M' and TRANS = 'N', or MATBLK = 'B' and TRANS='C';
*          and the column block size of the matrix A if MATBLK = 'M' and
*          TRANS = 'C', or MATBLK = 'B' and TRANS = 'N'.  NB >= 1.
*
*  ALPHA   (input) REAL
*          ALPHA specifies the scalar alpha.
*
*  A       (input) COMPLEX array of local DIMENSION ( LDA, ka ),
*          where ka is Kq when TRANS = 'N', or Nq otherwise.
*          If TRANS = 'N', the leading Np-by-Kq part of the array A
*          must contain the (local) matrix A, otherwise the leading Kp-
*          by-Nq part of the array A must contain the (local) matrix A.
*
*  LDA     (input) INTEGER
*          LDA specifies the leading dimension of (local) A as declared
*          in the calling (sub) program.
*          LDA >= MAX(1,Np) if MATBLK = 'M' & TRANS = 'N',
*                           or MATBLK = 'B' & TRANS = 'C',
*          LDA >= MAX(1,Kp) if MATBLK = 'M' & TRANS = 'C',
*                           or MATBLK = 'B' & TRANS = 'N'.
*  BETA    (input) REAL
*          BETA specifies the scalar beta.
*
*  C       (input/output) COMPLEX array of local DIMENSION ( LDC, Nq ).
*          On entry with UPLO = 'U', the leading N-by-N upper triangular
*          part of the (global) array C must contain the upper triangu-
*          lar part  of the  Hermitian matrix  and the strictly lower
*          triangular part  of C is not referenced. On exit, the upper
*          triangular part of the array  C is overwritten by the upper
*          triangular part of the updated  matrix.
*          On entry with  UPLO='L', the leading N-by-N lower triangular
*          part of the (global) array C  must  contain the lower
*          triangular  part  of the  Hermitian  matrix and the strictly
*          upper triangular part of C is not referenced.  On exit,
*          the lower triangular part of the array C is overwritten by
*          the lower triangular part of the updated matrix.
*
*  LDC     (input) INTEGER
*          LDC specifies the leading dimension of (local) C as declared
*          in the calling (sub) program.  LDC >= MAX(1,Np).
*
*  IAPOS   (input) INTEGER
*          If TRANS = 'N', IAPOS specifies a column of process
*          template, which holds the first block of A.  And if TRANS =
*          'C', IAPOS specifies a row of the template, which holds the
*          first block of A.  If MATBLK = 'M' and all columns or rows
*          of processes have a copy of A, then set IAPOS = -1.
*
*  ICROW   (input) INTEGER
*          It specifies a row of process template which has the
*          first block of C.  It also represents the first (row)
*          process of the column block C if TRANS = 'N'.
*          When MATBLK = 'B', and all rows of processes have their
*          own copies of C, set ICROW =  -1.
*
*  ICCOL   (input) INTEGER
*          It specifies a column of process template which has the
*          first block of C.  It also represents the  first (column)
*          process  of the row block C if TRANS = 'C'.
*          When MATBLK = 'B', and all columns of processes have
*          their own copies of C, set ICCOL = -1.
*
*  ACOMM   (input) CHARACTER*1
*          When MATBLK = 'M', ACOMM specifies the communication scheme
*          of column or row block of A if communication is necessary.
*          It follows topology definition of BLACS.
*          When MATBLK = 'B', the argument is ignored.
*
*  AWORK   (input) CHARACTER*1
*          When MATBLK = 'M', AWORK determines whether A is a
*          workspace or not.
*
*             AWORK = 'Y':  A is workspace in other processes.
*                           A is sent to A position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) A.
*             AWORK = 'N':  Data in A will be untouched (unchanged).
*
*          When MATBLK = 'B', it is ignored.
*
*  CWORK   (input) CHARACTER*1
*          When MATBLK = 'M', CWORK determines whether the other
*          triangular part of C is accessed and modified or not.
*
*            CWORK = 'N': if UPLO = 'U', only upper triangular portion
*                         portion of the matrix C is accessed and the
*                         lower triangular portion is untouched.
*                         Likewise if UPLO = 'L', only lower triangular
*                         portion of the matrix C is accessed and the
*                         upper triangular portion is untouched.
*            CWORK = 'Y': if UPLO = 'U', only lower triangular portion
*                         of the matrix C may be accessed and modified
*                         for fast computation.  And if UPLO = 'L', the
*                         upper triangular portion of the matrix C may
*                         be accessed and modified for fast computation.
*
*          And when MATBLK = 'B', CWORK determines whether C is a
*          workspace or not.
*
*             CWORK = 'Y':  C is workspace in other processes.
*                           C is sent to C position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store C.
*             CWORK = 'N':  Data in C will be untouched (unchanged)
*                           in other processes.
*
*  MULLEN  (input) INTEGER
*          When MATBLK = 'M', MULLEN specifies multiplication length of
*          the optimum column number of a row block A if TRANS = 'C',
*          or A' if TRANS = 'N' for multiplying A with A'.  The value
*          depends on machine characteristics.
*          When MATBLK = 'B', it is ignored.
*
*  WORK    (workspace) COMPLEX array of dimension Size(WORK).
*          It will store copy of A and/or A'.
*
*  Parameters Details
*  ==================
*
*  Lx      It is  a local portion  of L  owned  by  a process,  (L is
*          replaced by M, or N,  and x  is replaced  by  either  p
*          (=NPROW) or q (=NPCOL)).  The value is determined by  L, LB,
*          x, and MI,  where  LB is  a block size  and MI is a  row  or
*          column position in a process template.  Lx is equal to  or
*          less than  Lx0 = CEIL( L, LB*x ) * LB.
*
*  Memory Requirement of WORK
*  ==========================
*
*  Npb    = CEIL( N, NB*NPROW )
*  Nqb    = CEIL( N, NB*NPCOL )
*  Np0    = NUMROC( N, NB, 0, 0, NPROW ) ~= Npb * NB
*  Nq0    = NUMROC( N, NB, 0, 0, NPCOL ) ~= Nqb * NB
*  LCMQ   = LCM / NPCOL
*  LCMP   = LCM / NPROW
*  ISZCMP = CEIL(MULLEN, LCMQ*NB)
*  SZCMP  = ISZCMP * ISZCMP * LCMQ*NB * LCMP*NB
*
*  (1) MATBLK = 'M'
*    (a) TRANS = 'N'
*    Size(WORK) = K * Nq0
*               + K * Np0        ( if IAPOS <> -1 and AWORK <> 'Y' )
*               + MAX[ SZCMP                     ( if CWORK <> 'Y' ),
*                      K*CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(N,NB) ]
*    (b) TRANS = 'C'
*    Size(WORK) = K * Np0
*               + K * Nq0        ( if IAPOS <> -1 and AWORK <> 'Y' )
*               + MAX[ SZCMP                     ( if CWORK <> 'Y' ),
*                      K*CEIL(Npb,LCMP)*NB*MIN(LCMP,CEIL(N,NB) ]
*
*  (2) MATBLK = 'B'
*    (a) TRANS = 'N'     (on a row of processes ICROW only )
*    Size(WORK) = N * (N+1) / 2     ( if CWORK =  'Y')
*    Size(WORK) = N * N             ( if CWORK <> 'Y')
*    (b) TRANS = 'C' (on a column of processes ICCOL only )
*    Size(WORK) = N * (N+1) / 2     ( if CWORK =  'Y')
*    Size(WORK) = N * N             ( if CWORK <> 'Y')
*
*  Notes
*  -----
*  More precise space can be computed as
*
*  CEIL(Nqb,LCMQ)*NB => NUMROC( NUMROC(N,NB,0,0,NPCOL), NB, 0, 0, LCMQ )
*                    = NUMROC( Nq0, NB, 0, 0, LCMQ )
*  CEIL(Npb,LCMP)*NB => NUMROC( NUMROC(N,NB,0,0,NPROW), NB, 0, 0, LCMP )
*                    = NUMROC( Np0, NB, 0, 0, LCMP )
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               RONE, RZERO
      PARAMETER          ( RONE = 1.0E+0, RZERO = 0.0E+0 )
      COMPLEX            ONE,  ZERO
      PARAMETER          ( ONE  = ( 1.0E+0, 0.0E+0 ),
     $                   ZERO = ( 0.0E+0, 0.0E+0 ) )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        COMMA, FORM
      LOGICAL            ADATA, ASPACE, CMAT, CSPACE, NOTRAN, UPPER
      INTEGER            INFO, IPBZ, IPT, IPW, IQBZ, ISZCMP, JJ, JNPBZ,
     $                   JPBZ, JQBZ, KI, KIZ, KJ, KJZ, LCM, LCMP, LCMQ,
     $                   LKK, LMW, LNW, LPBZ, LQBZ, MRCOL, MRROW, MYCOL,
     $                   MYROW, MZCOL, MZROW, NP, NPCOL, NPROW, NQ
      COMPLEX            TALPHA, TBETA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, ILCM, NUMROC
      EXTERNAL           ICEIL, ILCM, LSAME, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CGEBR2D, CGEBS2D, CGEMM, CHERK,
     $                   PBCMATADD, PBCT1CPY, PBCT2CPY, PBCT3CPY,
     $                   PBCTRADD, PBCTRAN, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CMPLX, MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible.
*
      IF( N.EQ.0 .OR.
     $    ( ( ALPHA.EQ.RZERO .OR. K.EQ.0 ) .AND. BETA.EQ.RONE ) )
     $   RETURN
*
      CALL BLACS_GRIDINFO( ICONTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      CMAT   = LSAME( MATBLK, 'M' )
      UPPER  = LSAME( UPLO,   'U' )
      NOTRAN = LSAME( TRANS,  'N' )
*
*     Test the input parameters.
*
      INFO = 0
      IF(      ( .NOT.CMAT                 ).AND.
     $         ( .NOT.LSAME( MATBLK, 'B' ) )         ) THEN
         INFO = 2
      ELSE IF( ( .NOT.UPPER                ).AND.
     $         ( .NOT.LSAME( UPLO,   'L' ) )         ) THEN
         INFO = 3
      ELSE IF( ( .NOT.NOTRAN               ).AND.
     $         ( .NOT.LSAME( TRANS,  'C' ) )         ) THEN
         INFO = 4
      ELSE IF( N  .LT.0                              ) THEN
         INFO = 5
      ELSE IF( K  .LT.0                              ) THEN
         INFO = 6
      ELSE IF( NB .LT.1                              ) THEN
         INFO = 7
      END IF
*
   10 CONTINUE
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICONTXT, 'PBCHERK ', INFO )
         RETURN
      END IF
*
*     Start the operations.
*
* === If C is a matrix ===
*
      IF( CMAT ) THEN
        NP = NUMROC( N, NB, MYROW, ICROW, NPROW )
        NQ = NUMROC( N, NB, MYCOL, ICCOL, NPCOL )
*
        IF( LDC.LT.MAX(1,NP)                    ) THEN
          INFO = 13
        ELSE IF( ICROW.LT.0 .OR. ICROW.GE.NPROW ) THEN
          INFO = 15
        ELSE IF( ICCOL.LT.0 .OR. ICCOL.GE.NPCOL ) THEN
          INFO = 16
        END IF
*
        ADATA  = .FALSE.
        IF( IAPOS.EQ.-1 ) ADATA = .TRUE.
        CSPACE = LSAME( CWORK, 'Y' )
        ASPACE = LSAME( AWORK, 'Y' )
        COMMA = ACOMM
        IF( LSAME( COMMA, ' ' ) ) COMMA = '1'
*
*       LCM : the least common multiple of NPROW and NPCOL
*
        LCM  = ILCM( NPROW, NPCOL )
        LCMP = LCM  / NPROW
        LCMQ = LCM  / NPCOL
        LPBZ = LCMP * NB
        LQBZ = LCMQ * NB
*
        MRROW = MOD( NPROW+MYROW-ICROW, NPROW )
        MRCOL = MOD( NPCOL+MYCOL-ICCOL, NPCOL )
        TALPHA = CMPLX( ALPHA )
        TBETA  = CMPLX( BETA )
        LKK = MAX( 1, K )
*
*       PART 1: Distribute a column (or row) block A and its transpose A
*       ================================================================
*
        IF( NOTRAN ) THEN
*
*         Form  C := alpha*A*A' + beta*C.
*       _____________         _                           _____________
*      |\_           |       | |                         |\_           |
*      |  \_         |       | |                         |  \_         |
*      |    \_       |       | |    _____________        |    \_       |
*      |      C_     | = a * |A| * |_____(A')____| + b * |      C_     |
*      |        \_   |       | |                         |        \_   |
*      |          \_ |       | |                         |          \_ |
*      |____________\|       |_|                         |____________\|
*
          IF( LDA.LT.MAX(1,NP) .AND. ( ASPACE .OR.
     $        IAPOS.EQ.MYCOL .OR. IAPOS.EQ.-1 )    ) THEN
            INFO = 10
          ELSE IF( IAPOS.LT.-1 .OR. IAPOS.GE.NPCOL ) THEN
            INFO = 14
          END IF
          IF( INFO.NE.0 ) GO TO 10
*
*         Broadcast A if necessary
*
          IPT = 1
          IF( .NOT.ADATA ) THEN
            IF( ASPACE ) THEN
              IF( MYCOL.EQ.IAPOS ) THEN
                CALL CGEBS2D( ICONTXT, 'Row', COMMA, NP, K, A, LDA )
              ELSE
                CALL CGEBR2D( ICONTXT, 'Row', COMMA, NP, K, A, LDA,
     $                        MYROW, IAPOS )
              END IF
              ADATA = .TRUE.
            ELSE
              IF( MYCOL.EQ.IAPOS ) THEN
                CALL PBCMATADD( ICONTXT, 'V', NP, K, ONE, A, LDA, ZERO,
     $                          WORK, NP )
                CALL CGEBS2D( ICONTXT, 'Row', COMMA, NP, K, WORK, NP )
              ELSE
                CALL CGEBR2D( ICONTXT, 'Row', COMMA, NP, K, WORK, NP,
     $                        MYROW, IAPOS )
              END IF
              IPT = NP * K + 1
            END IF
          END IF
*
*         Transpose col block of A to WORK(IPT), where A is distributed
*
          IPW = K * NQ + IPT
          IF( ADATA ) THEN
            CALL PBCTRAN( ICONTXT, 'Col', 'C', N, K, NB, A, LDA, ZERO,
     $                    WORK(IPT), K, ICROW, -1, -1, ICCOL,
     $                    WORK(IPW) )
          ELSE
            CALL PBCTRAN( ICONTXT, 'Col', 'C', N, K, NB, WORK, NP, ZERO,
     $                    WORK(IPT), K, ICROW, -1, -1, ICCOL,
     $                    WORK(IPW) )
          END IF
*
        ELSE
*
*         Form  C := alpha*A'*A + beta*C.
*       _____________          _                          _____________
*      |\_           |        | |                        |\_           |
*      |  \_         |        | |                        |  \_         |
*      |    \_       |        | |   _____________        |    \_       |
*      |      C_     | = a * ( A')*|______A______| + b * |      C_     |
*      |        \_   |        | |                        |        \_   |
*      |          \_ |        | |                        |          \_ |
*      |____________\|        |_|                        |____________\|
*
          IF( LDA.LT.MAX(1,K) .AND. ( ASPACE .OR.
     $        IAPOS.EQ.MYROW .OR. IAPOS.EQ.-1 )    ) THEN
            INFO = 10
          ELSE IF( IAPOS.LT.-1 .OR. IAPOS.GE.NPROW ) THEN
            INFO = 14
          END IF
          IF( INFO.NE.0 ) GO TO 10
*
*         Broadcast A if necessary
*
          IPT= 1
          IF( .NOT.ADATA ) THEN
            IF( ASPACE ) THEN
              IF( MYROW.EQ.IAPOS ) THEN
                CALL CGEBS2D( ICONTXT, 'Col', COMMA, K, NQ, A, LDA )
              ELSE
                CALL CGEBR2D( ICONTXT, 'Col', COMMA, K, NQ, A, LDA,
     $                        IAPOS, MYCOL )
              END IF
              ADATA = .TRUE.
            ELSE
              IF( MYROW.EQ.IAPOS ) THEN
                CALL PBCMATADD( ICONTXT, 'G', K, NQ, ONE, A, LDA, ZERO,
     $                          WORK, K )
                CALL CGEBS2D( ICONTXT, 'Col', COMMA, K, NQ, WORK, K )
              ELSE
                CALL CGEBR2D( ICONTXT, 'Col', COMMA, K, NQ, WORK, K,
     $                        IAPOS, MYCOL )
              END IF
              IPT = K * NQ + 1
            END IF
          END IF
*
*         Transpose row block of A to WORK(IPT), where A is distributed
*
          IPW = NP * K + IPT
          IF( ADATA ) THEN
            CALL PBCTRAN( ICONTXT, 'Row', 'C', K, N, NB, A, LDA, ZERO,
     $                    WORK(IPT), NP, -1, ICCOL, ICROW, -1,
     $                    WORK(IPW) )
          ELSE
            CALL PBCTRAN( ICONTXT, 'Row', 'C', K, N, NB, WORK,K, ZERO,
     $                    WORK(IPT), NP, -1, ICCOL, ICROW, -1,
     $                    WORK(IPW) )
          END IF
        END IF
*
*       PART 2: Update C with A and A'
*       ==============================
*
        IF( NP.EQ.0 .OR. NQ.EQ.0 ) RETURN
*
*       If C is a Hermitian upper triangular matrix,
*
        IF( UPPER ) THEN
          ISZCMP = ICEIL( MULLEN, LQBZ )
          IF( ISZCMP.LE.0 ) ISZCMP = 1
          IPBZ = ISZCMP * LPBZ
          IQBZ = ISZCMP * LQBZ
          JPBZ = 0
          JQBZ = 0
*
          DO 40 JJ = 1, ICEIL(NQ, IQBZ)
            LMW = MIN( IPBZ, NP-JPBZ )
            LNW = MIN( IQBZ, NQ-JQBZ )
            JNPBZ = JPBZ + LMW
*
*           Modify (change) data in the lower triangular part
*
            IF( CSPACE ) THEN
*
*             Update C := alpha*A*A' + beta*C, if TRANS = 'N'
*
              IF( NOTRAN ) THEN
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', JNPBZ, LNW, K, TALPHA,
     $                        A, LDA, WORK(JQBZ*K+IPT), LKK, TBETA,
     $                        C(1,JQBZ+1), LDC )
                ELSE
                  CALL CGEMM( 'No', 'No', JNPBZ, LNW, K, TALPHA,
     $                        WORK, NP, WORK(JQBZ*K+IPT), LKK, TBETA,
     $                        C(1,JQBZ+1), LDC )
                END IF
*
*             Update C := alpha*A'*A + beta*C, if TRANS = 'C'
*
              ELSE
                IF( ADATA ) THEN
                   CALL CGEMM( 'No', 'No', JNPBZ, LNW, K, TALPHA,
     $                         WORK(IPT), NP, A(1,JQBZ+1), LDA, TBETA,
     $                         C(1,JQBZ+1), LDC )
                ELSE
                   CALL CGEMM( 'No', 'No', JNPBZ, LNW, K, TALPHA,
     $                         WORK(IPT), NP, WORK(JQBZ*K+1), LKK,
     $                         TBETA, C(1,JQBZ+1), LDC )
                END IF
              END IF
*
*           Update data in the upper triangular matrix
*           and save data in the lower triangular matrix
*
            ELSE
*
*             Update C := alpha*A*A' + beta*C, if TRANS = 'N'
*
              IF( NOTRAN ) THEN
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', JPBZ, LNW, K, TALPHA,
     $                        A, LDA, WORK(JQBZ*K+IPT), LKK, TBETA,
     $                        C(1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        A(JPBZ+1,1), LDA, WORK(JQBZ*K+IPT), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                ELSE
                  CALL CGEMM( 'No', 'No', JPBZ, LNW, K, TALPHA,
     $                        WORK, NP, WORK(JQBZ*K+IPT), LKK, TBETA,
     $                        C(1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+1), NP, WORK(JQBZ*K+IPT), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                END IF
*
*             Update C := alpha*A'*A + beta*C, if TRANS = 'C'
*
              ELSE
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', JPBZ, LNW, K, TALPHA,
     $                        WORK(IPT), NP, A(1,JQBZ+1), LDA,
     $                        TBETA, C(1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, A(1,JQBZ+1), LDA,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                ELSE
                  CALL CGEMM( 'No', 'No', JPBZ, LNW, K, TALPHA,
     $                        WORK(IPT), NP, WORK(JQBZ*K+1), LKK,
     $                        TBETA, C(1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, WORK(JQBZ*K+1), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                END IF
              END IF
*
*             Compute diagonal blocks.
*
              MZROW = MRROW
              MZCOL = MRCOL
              KI = 0
*
              DO 30 KJ = 0, LCMQ-1
   20            CONTINUE
                 IF( MZROW.LT.MZCOL ) THEN
                    MZROW = MZROW + NPROW
                    KI = KI + 1
                    GO TO 20
                 END IF
                 KIZ = KI * NB
                 KJZ = KJ * NB
                 IF( KJZ.GE.LNW )
     $              GO TO 40
                 FORM = 'G'
                 IF( MZROW.EQ.MZCOL )
     $              FORM = 'H'
                 MZCOL = MZCOL + NPCOL
*
                 CALL PBCTRADD( ICONTXT, 'Upper', FORM, KIZ, NB, ONE,
     $                          WORK( KJZ*LMW+IPW ), LMW, TBETA,
     $                          C( JPBZ+1, JQBZ+KJZ+1 ), LDC,
     $                          LPBZ, LQBZ, LMW, LNW-KJZ )
   30         CONTINUE
            END IF
*
            JPBZ = JNPBZ
            JQBZ = JQBZ + LNW
   40     CONTINUE
*
*       If C is a Hermitian lower triangular matrix,
*
        ELSE
*
          ISZCMP = ICEIL( MULLEN, LQBZ )
          IF( ISZCMP.LE.0 ) ISZCMP = 1
          IPBZ = ISZCMP * LPBZ
          IQBZ = ISZCMP * LQBZ
          JPBZ = 0
          JQBZ = 0
*
          DO 70 JJ = 1, ICEIL(NQ, IQBZ)
            LMW = MIN( IPBZ, MAX(NP-JPBZ, 0) )
            LNW = MIN( IQBZ, MAX(NQ-JQBZ, 0) )
            JNPBZ = JPBZ + LMW
*
*           Modify (change) data in the upper triangular part
*
            IF( CSPACE ) THEN
*
*             Update C := alpha*A*A' + beta*C, if TRANS = 'N'
*
              IF( NOTRAN ) THEN
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', NP-JPBZ, LNW, K, TALPHA,
     $                        A(JPBZ+1,1), LDA, WORK(JQBZ*K+IPT), LKK,
     $                        TBETA, C(JPBZ+1,JQBZ+1), LDC )
                ELSE
                  CALL CGEMM( 'No', 'No', NP-JPBZ, LNW, K, TALPHA,
     $                        WORK(JPBZ+1), NP, WORK(JQBZ*K+IPT), LKK,
     $                        TBETA, C(JPBZ+1,JQBZ+1), LDC )
                END IF
*
*             Update C := alpha*A'*A + beta*C, if TRANS = 'C'
*
              ELSE
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', NP-JPBZ, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, A(1,JQBZ+1), LDA,
     $                        TBETA, C(JPBZ+1,JQBZ+1), LDC )
                ELSE
                  CALL CGEMM( 'No', 'No', NP-JPBZ, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, WORK(JQBZ*K+1), LKK,
     $                        TBETA, C(JPBZ+1,JQBZ+1), LDC )
                END IF
              END IF
*
*           Update data in the lower triangular matrix
*           and save data in the upper triangular matrix
*
            ELSE
*
*             Update C := alpha*A*A' + beta*C, if TRANS = 'N'
*
              IF( NOTRAN ) THEN
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', NP-JNPBZ, LNW, K, TALPHA,
     $                        A(JNPBZ+1,1), LDA, WORK(JQBZ*K+IPT), LKK,
     $                        TBETA, C(JNPBZ+1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        A(JPBZ+1,1), LDA, WORK(JQBZ*K+IPT), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                ELSE
                  CALL CGEMM( 'No', 'No', NP-JNPBZ, LNW, K, TALPHA,
     $                        WORK(JNPBZ+1), NP, WORK(JQBZ*K+IPT), LKK,
     $                        TBETA, C(JNPBZ+1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+1), NP, WORK(JQBZ*K+IPT), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                END IF
*
*             Update C := alpha*A'*A + beta*C, if TRANS = 'C'
*
              ELSE
                IF( ADATA ) THEN
                  CALL CGEMM( 'No', 'No', NP-JNPBZ, LNW, K, TALPHA,
     $                        WORK(JNPBZ+IPT), NP, A(1,JQBZ+1), LDA,
     $                        TBETA, C(JNPBZ+1,JQBZ+1), LDC )
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, A(1,JQBZ+1), LDA,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                ELSE
                  CALL CGEMM( 'No', 'No', NP-JNPBZ, LNW, K, TALPHA,
     $                        WORK(JNPBZ+IPT), NP, WORK(JQBZ*K+1), LKK,
     $                        TBETA, C(JNPBZ+1,JQBZ+1), LDC)
                  CALL CGEMM( 'No', 'No', LMW, LNW, K, TALPHA,
     $                        WORK(JPBZ+IPT), NP, WORK(JQBZ*K+1), LKK,
     $                        ZERO, WORK(IPW), MAX(1,LMW) )
                END IF
              END IF
*
*             Compute diagonal blocks.
*
              MZROW = MRROW
              MZCOL = MRCOL
              KI = 0
*
              DO 60 KJ = 0, LCMQ-1
   50            CONTINUE
                 IF( MZROW.LT.MZCOL ) THEN
                    MZROW = MZROW + NPROW
                    KI = KI + 1
                    GO TO 50
                 END IF
                 KIZ = KI * NB
                 KJZ = KJ * NB
                 IF( KJZ.GE.LNW )
     $              GO TO 70
                 FORM = 'G'
                 IF( MZROW.EQ.MZCOL )
     $              FORM = 'H'
                 MZCOL = MZCOL + NPCOL
*
                 CALL PBCTRADD( ICONTXT, 'Lower', FORM, KIZ, NB, ONE,
     $                          WORK( KJZ*LMW+IPW ), LMW, TBETA,
     $                          C( JPBZ+1, JQBZ+KJZ+1 ), LDC,
     $                          LPBZ, LQBZ, LMW, LNW-KJZ )
   60         CONTINUE
            END IF
*
            JPBZ = JNPBZ
            JQBZ = JQBZ + LNW
   70     CONTINUE
        END IF
*
* === If C is just a block ===
*
      ELSE
        IF( NOTRAN .AND. MYROW.EQ.ICROW ) THEN
*
*         Form  C := alpha * A * (A') + beta * C.
*                                            _
*                                           | |
*                                           | |
*            _             _____________    | |            _
*           |_| = alpha * |______A______| * (A') + beta * |_|
*            C                              | |            C
*                                           | |
*                                           |_|
*
          NQ = NUMROC( K, NB, MYCOL, IAPOS, NPCOL )
          CSPACE = LSAME( CWORK, 'Y' )
*
          IF( LDA.LT.MAX(1,N)                          ) THEN
            INFO = 10
          ELSE IF( LDC.LT.MAX(1,N) .AND. ( CSPACE .OR.
     $             ICCOL.EQ.MYCOL .OR. ICCOL.EQ.-1 )   ) THEN
            INFO = 13
          ELSE IF( IAPOS.LT.0  .OR. IAPOS.GE.NPCOL     ) THEN
            INFO = 14
          ELSE IF( ICROW.LT.0  .OR. ICROW.GE.NPROW     ) THEN
            INFO = 15
          ELSE IF( ICCOL.LT.-1 .OR. ICCOL.GE.NPCOL     ) THEN
            INFO = 16
          END IF
          IF( INFO.NE.0 ) GO TO 10
*
*         Compute C
*
          IF( MYCOL.EQ.ICCOL ) THEN
            CALL CHERK( UPLO, TRANS, N, NQ, ALPHA, A,LDA, BETA, C,LDC )
            CALL PBCT1CPY( UPLO, JJ, N, C, LDC, WORK )
            CALL CGSUM2D( ICONTXT, 'Row', '1-tree', 1, JJ, WORK, 1,
     $                    ICROW, ICCOL )
            CALL PBCT2CPY( UPLO, JJ, N, C, LDC, WORK )
*
          ELSE
            IF( LSAME( CWORK, 'Y' ) ) THEN
              CALL CHERK( UPLO, TRANS, N, NQ, ALPHA, A, LDA, RZERO,
     $                    C, LDC )
              CALL PBCT1CPY( UPLO, JJ, N, C, LDC, WORK )
              CALL CGSUM2D( ICONTXT, 'Row', '1-tree', 1, JJ, WORK, 1,
     $                      ICROW, ICCOL )
            ELSE
              CALL CHERK( UPLO, TRANS, N, NQ, ALPHA, A, LDA, RZERO,
     $                    WORK, N )
              CALL PBCT3CPY( UPLO, JJ, N, WORK )
              CALL CGSUM2D( ICONTXT, 'Row', '1-tree', 1, JJ, WORK, 1,
     $                      ICROW, ICCOL )
            END IF
          END IF
*
        ELSE IF( LSAME( TRANS, 'C' ) .AND. MYCOL.EQ.ICCOL ) THEN
*
*         Form  B := alpha*B / op( A ).
*                                            _
*                                           | |
*                                           | |
*            _             _____________    | |           _
*           |_| = alpha * |_____(A')____| * |A| + beta * |_|
*            C                              | |           C
*                                           | |
*                                           |_|
*
          NP = NUMROC( K, NB, MYROW, IAPOS, NPROW )
          CSPACE = LSAME( CWORK, 'Y' )
*
          IF( LDA.LT.MAX(1,NP)                         ) THEN
            INFO = 10
          ELSE IF( LDC.LT.MAX(1,N) .AND. ( CSPACE .OR.
     $             ICROW.EQ.MYROW .OR. ICROW.EQ.-1 )   ) THEN
            INFO = 13
          ELSE IF( IAPOS.LT.0  .OR. IAPOS.GE.NPROW     ) THEN
            INFO = 14
          ELSE IF( ICROW.LT.-1 .OR. ICROW.GE.NPROW     ) THEN
            INFO = 15
          ELSE IF( ICCOL.LT.0  .OR. ICCOL.GE.NPCOL     ) THEN
            INFO = 16
          END IF
          IF( INFO.NE.0 ) GO TO 10
*
*         Compute C
*
          IF( MYROW.EQ.ICROW ) THEN
            CALL CHERK( UPLO, TRANS, N, NP, ALPHA, A,LDA, BETA, C,LDC )
            CALL PBCT1CPY( UPLO, JJ, N, C, LDC, WORK )
            CALL CGSUM2D( ICONTXT, 'Col', '1-tree', 1, JJ, WORK, 1,
     $                    ICROW, ICCOL )
            CALL PBCT2CPY( UPLO, JJ, N, C, LDC, WORK )
*
          ELSE
            IF( LSAME( CWORK, 'Y' ) ) THEN
              CALL CHERK( UPLO, TRANS, N, NP, ALPHA, A, LDA, RZERO,
     $                    C, LDC )
              CALL PBCT1CPY( UPLO, JJ, N, C, LDC, WORK )
              CALL CGSUM2D( ICONTXT, 'Col', '1-tree', 1, JJ, WORK, 1,
     $                      ICROW, ICCOL )
            ELSE
              CALL CHERK( UPLO, TRANS, N, NP, ALPHA, A, LDA, RZERO,
     $                    WORK, N )
              CALL PBCT3CPY( UPLO, JJ, N, WORK )
              CALL CGSUM2D( ICONTXT, 'Col', '1-tree', 1, JJ, WORK, 1,
     $                      ICROW, ICCOL )
            END IF
          END IF
        END IF
      END IF
*
      RETURN
*
*     End of PBCHERK
*
      END
