/* $Id: pviewer.h,v 1.20 1998/04/20 19:32:46 bsmith Exp $ */

/*
    Defines private information about viewers, application codes should 
  usually not include this file.
*/
#if !defined(__PVIEWER_H)
#define __PVIEWER_H

#include "viewer.h"

/*
    Common structure shared by all viewers
*/
#define VIEWERHEADER \
        PETSCHEADER(int) \
        int   (*destroy)(Viewer);\
        int   (*view)(Viewer,Viewer);\
        int   (*flush)(Viewer); \
        int   format,formats[10],iformat;

extern int  ViewerFileGetOutputname_Private(Viewer,char**);  
extern int  ViewerMatlabPutScalar_Private(Viewer,int,int,Scalar*);
extern int  ViewerMatlabPutDouble_Private(Viewer,int,int,double*);
extern int  ViewerMatlabPutInt_Private(Viewer,int,int*);
extern int  ViewerMatlabPutSparse_Private(Viewer,int,int,int,Scalar*,int*,int *);
extern int  ViewerInitialize_Private(void);
extern int  ViewerDestroy_Private(void);
extern int  ViewerDestroyDrawX_Private(void);
extern int  ViewerDestroyMatlab_Private(void);

#endif
