#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: vrmlopen.c,v 1.10 1997/10/19 03:27:58 bsmith Exp $";
#endif

/*
 * This file contains code to either dynamically load the VRML drawing
 * code or to ensure that it is already linked in.
 */

#include "src/draw/impls/vrml/vrmlimpl.h"

#if defined(USE_DYNAMIC_LOADING)

#if defined(HAVE_DLOPEN)
#include <dlfcn.h>

if (!(vrml_handle = dlopen( path_to_vrml_lib, RTLD_LAZY ))) {
    /* Error, could not get library */
}
/* Find the symbols */
fptr = (int (*)(....)) dlsym( vrml_handle, "DrawLine_VRML" );
...

/* To unload the handle */
dlclose( vrml_handle );

#else
#endif

#else /* No Dynamic Loading */
/* Just define the entry points */

#endif

/*
  Dynamic entry points 
 */
#undef __FUNC__  
#define __FUNC__ "DrawTensorSurface"
int DrawTensorSurface( Draw Win, DrawMesh mesh, int ncolor )
{
    Draw_VRML *VWin = (Draw_VRML*) Win->data;
    PetscObject vobj = (PetscObject) Win;

    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

    return (*VWin->DrawTensorSurface)( Win, mesh, ncolor );
}

#undef __FUNC__  
#define __FUNC__ "DrawTensorSurfaceContour"
int DrawTensorSurfaceContour( Draw Win, DrawMesh mesh, VRMLGetHue_fcn getcolor,
			      void *color_context, int ncolor )
{
    Draw_VRML *VWin = (Draw_VRML*) Win->data;
    PetscObject vobj = (PetscObject) Win;

    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

    return (*VWin->DrawTensorSurfaceContour)( Win, mesh, getcolor, 
					      color_context, ncolor );
}

#undef __FUNC__  
#define __FUNC__ "DrawTensorMapSurfaceContour"
int      DrawTensorMapSurfaceContour( Draw Win, DrawMesh mesh, 
				      double ox, double oy, double oz, 
				      int coord_slice, int coord_dim,
				      VRMLGetHue_fcn GetColor,
				      void *color_context, int ncolor, 
				      double transparency )
{
    Draw_VRML *VWin = (Draw_VRML*) Win->data;
    PetscObject vobj = (PetscObject) Win;

    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

    return (*VWin->DrawTensorMapSurfaceContour)( Win, mesh, ox, oy, oz, 
						 coord_slice, coord_dim,
						 GetColor, color_context, 
						 ncolor, transparency );
}

#undef __FUNC__  
#define __FUNC__ "DrawTensorMapMesh"
int DrawTensorMapMesh( Draw Win, DrawMesh mesh, 
		       double ox, double oy, double oz,
     		       int coord_slice, int coord_dim )
{
  Draw_VRML *VWin = (Draw_VRML*) Win->data;
  PetscObject vobj = (PetscObject) Win;

  if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

  return (*VWin->DrawTensorMapMesh)( Win, mesh, ox, oy, oz, coord_slice, coord_dim );
}
					  
