/* vector.c */
/* Fortran interface file */

/*
 * This file was generated automatically by bfort from the C source
 * file.  
 */

#ifdef USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "vec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetblocksize_ PVECSETBLOCKSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetblocksize_ pvecsetblocksize
#else
#define vecsetblocksize_ pvecsetblocksize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetblocksize_ VECSETBLOCKSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetblocksize_ vecsetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecvalid_ PVECVALID
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecvalid_ pvecvalid
#else
#define vecvalid_ pvecvalid_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecvalid_ VECVALID
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecvalid_ vecvalid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecdot_ PVECDOT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecdot_ pvecdot
#else
#define vecdot_ pvecdot_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecdot_ VECDOT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecdot_ vecdot
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecnorm_ PVECNORM
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnorm_ pvecnorm
#else
#define vecnorm_ pvecnorm_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecnorm_ VECNORM
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnorm_ vecnorm
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecmax_ PVECMAX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmax_ pvecmax
#else
#define vecmax_ pvecmax_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecmax_ VECMAX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmax_ vecmax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecmin_ PVECMIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmin_ pvecmin
#else
#define vecmin_ pvecmin_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecmin_ VECMIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmin_ vecmin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vectdot_ PVECTDOT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vectdot_ pvectdot
#else
#define vectdot_ pvectdot_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vectdot_ VECTDOT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vectdot_ vectdot
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecscale_ PVECSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecscale_ pvecscale
#else
#define vecscale_ pvecscale_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecscale_ VECSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecscale_ vecscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define veccopy_ PVECCOPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define veccopy_ pveccopy
#else
#define veccopy_ pveccopy_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define veccopy_ VECCOPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define veccopy_ veccopy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecset_ PVECSET
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecset_ pvecset
#else
#define vecset_ pvecset_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecset_ VECSET
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecset_ vecset
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecaxpy_ PVECAXPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpy_ pvecaxpy
#else
#define vecaxpy_ pvecaxpy_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecaxpy_ VECAXPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpy_ vecaxpy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecaxpby_ PVECAXPBY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpby_ pvecaxpby
#else
#define vecaxpby_ pvecaxpby_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecaxpby_ VECAXPBY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpby_ vecaxpby
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecaypx_ PVECAYPX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaypx_ pvecaypx
#else
#define vecaypx_ pvecaypx_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecaypx_ VECAYPX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaypx_ vecaypx
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecswap_ PVECSWAP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecswap_ pvecswap
#else
#define vecswap_ pvecswap_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecswap_ VECSWAP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecswap_ vecswap
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecwaxpy_ PVECWAXPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwaxpy_ pvecwaxpy
#else
#define vecwaxpy_ pvecwaxpy_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecwaxpy_ VECWAXPY
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwaxpy_ vecwaxpy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecpointwisemult_ PVECPOINTWISEMULT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisemult_ pvecpointwisemult
#else
#define vecpointwisemult_ pvecpointwisemult_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecpointwisemult_ VECPOINTWISEMULT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisemult_ vecpointwisemult
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecpointwisedivide_ PVECPOINTWISEDIVIDE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisedivide_ pvecpointwisedivide
#else
#define vecpointwisedivide_ pvecpointwisedivide_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecpointwisedivide_ VECPOINTWISEDIVIDE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisedivide_ vecpointwisedivide
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvalues_ PVECSETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalues_ pvecsetvalues
#else
#define vecsetvalues_ pvecsetvalues_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvalues_ VECSETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalues_ vecsetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvaluesblocked_ PVECSETVALUESBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblocked_ pvecsetvaluesblocked
#else
#define vecsetvaluesblocked_ pvecsetvaluesblocked_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvaluesblocked_ VECSETVALUESBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblocked_ vecsetvaluesblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmapping_ PVECSETLOCALTOGLOBALMAPPING
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmapping_ pvecsetlocaltoglobalmapping
#else
#define vecsetlocaltoglobalmapping_ pvecsetlocaltoglobalmapping_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmapping_ VECSETLOCALTOGLOBALMAPPING
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmapping_ vecsetlocaltoglobalmapping
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmappingblocked_ PVECSETLOCALTOGLOBALMAPPINGBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmappingblocked_ pvecsetlocaltoglobalmappingblocked
#else
#define vecsetlocaltoglobalmappingblocked_ pvecsetlocaltoglobalmappingblocked_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmappingblocked_ VECSETLOCALTOGLOBALMAPPINGBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmappingblocked_ vecsetlocaltoglobalmappingblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvalueslocal_ PVECSETVALUESLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalueslocal_ pvecsetvalueslocal
#else
#define vecsetvalueslocal_ pvecsetvalueslocal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvalueslocal_ VECSETVALUESLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalueslocal_ vecsetvalueslocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvaluesblockedlocal_ PVECSETVALUESBLOCKEDLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblockedlocal_ pvecsetvaluesblockedlocal
#else
#define vecsetvaluesblockedlocal_ pvecsetvaluesblockedlocal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetvaluesblockedlocal_ VECSETVALUESBLOCKEDLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblockedlocal_ vecsetvaluesblockedlocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecassemblybegin_ PVECASSEMBLYBEGIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblybegin_ pvecassemblybegin
#else
#define vecassemblybegin_ pvecassemblybegin_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecassemblybegin_ VECASSEMBLYBEGIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblybegin_ vecassemblybegin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecassemblyend_ PVECASSEMBLYEND
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblyend_ pvecassemblyend
#else
#define vecassemblyend_ pvecassemblyend_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecassemblyend_ VECASSEMBLYEND
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblyend_ vecassemblyend
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecgetsize_ PVECGETSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetsize_ pvecgetsize
#else
#define vecgetsize_ pvecgetsize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecgetsize_ VECGETSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetsize_ vecgetsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecgetlocalsize_ PVECGETLOCALSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetlocalsize_ pvecgetlocalsize
#else
#define vecgetlocalsize_ pvecgetlocalsize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecgetlocalsize_ VECGETLOCALSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetlocalsize_ vecgetlocalsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecgetownershiprange_ PVECGETOWNERSHIPRANGE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetownershiprange_ pvecgetownershiprange
#else
#define vecgetownershiprange_ pvecgetownershiprange_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecgetownershiprange_ VECGETOWNERSHIPRANGE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetownershiprange_ vecgetownershiprange
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define vecsetoption_ PVECSETOPTION
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetoption_ pvecsetoption
#else
#define vecsetoption_ pvecsetoption_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define vecsetoption_ VECSETOPTION
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetoption_ vecsetoption
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void vecsetblocksize_(Vec v,int *bs, int *__ierr ){
*__ierr = VecSetBlockSize(
	(Vec)PetscToPointer( (v) ),*bs);
}
void vecvalid_(Vec v,PetscTruth *flg, int *__ierr ){
*__ierr = VecValid(
	(Vec)PetscToPointer( (v) ),flg);
}
void vecdot_(Vec x,Vec y,Scalar *val, int *__ierr ){
*__ierr = VecDot(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),val);
}
void vecnorm_(Vec x,NormType *type,double *val, int *__ierr ){
*__ierr = VecNorm(
	(Vec)PetscToPointer( (x) ),*type,val);
}
void vecmax_(Vec x,int *p,double *val, int *__ierr ){
*__ierr = VecMax(
	(Vec)PetscToPointer( (x) ),p,val);
}
void vecmin_(Vec x,int *p,double *val, int *__ierr ){
*__ierr = VecMin(
	(Vec)PetscToPointer( (x) ),p,val);
}
void vectdot_(Vec x,Vec y,Scalar *val, int *__ierr ){
*__ierr = VecTDot(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),val);
}
void vecscale_(Scalar *alpha,Vec x, int *__ierr ){
*__ierr = VecScale(alpha,
	(Vec)PetscToPointer( (x) ));
}
void veccopy_(Vec x,Vec y, int *__ierr ){
*__ierr = VecCopy(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void vecset_(Scalar *alpha,Vec x, int *__ierr ){
*__ierr = VecSet(alpha,
	(Vec)PetscToPointer( (x) ));
}
void vecaxpy_(Scalar *alpha,Vec x,Vec y, int *__ierr ){
*__ierr = VecAXPY(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void vecaxpby_(Scalar *alpha,Scalar *beta,Vec x,Vec y, int *__ierr ){
*__ierr = VecAXPBY(alpha,beta,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void vecaypx_(Scalar *alpha,Vec x,Vec y, int *__ierr ){
*__ierr = VecAYPX(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void vecswap_(Vec x,Vec y, int *__ierr ){
*__ierr = VecSwap(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void vecwaxpy_(Scalar *alpha,Vec x,Vec y,Vec w, int *__ierr ){
*__ierr = VecWAXPY(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void vecpointwisemult_(Vec x,Vec y,Vec w, int *__ierr ){
*__ierr = VecPointwiseMult(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void vecpointwisedivide_(Vec x,Vec y,Vec w, int *__ierr ){
*__ierr = VecPointwiseDivide(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void vecsetvalues_(Vec x,int *ni,int *ix,Scalar *y,InsertMode *iora, int *__ierr ){
*__ierr = VecSetValues(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void vecsetvaluesblocked_(Vec x,int *ni,int *ix,Scalar *y,InsertMode *iora, int *__ierr ){
*__ierr = VecSetValuesBlocked(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void vecsetlocaltoglobalmapping_(Vec x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = VecSetLocalToGlobalMapping(
	(Vec)PetscToPointer( (x) ),
	(ISLocalToGlobalMapping)PetscToPointer( (mapping) ));
}
void vecsetlocaltoglobalmappingblocked_(Vec x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = VecSetLocalToGlobalMappingBlocked(
	(Vec)PetscToPointer( (x) ),
	(ISLocalToGlobalMapping)PetscToPointer( (mapping) ));
}
void vecsetvalueslocal_(Vec x,int *ni,int *ix,Scalar *y,InsertMode *iora, int *__ierr ){
*__ierr = VecSetValuesLocal(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void vecsetvaluesblockedlocal_(Vec x,int *ni,int *ix,Scalar *y,InsertMode *iora, int *__ierr ){
*__ierr = VecSetValuesBlockedLocal(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void vecassemblybegin_(Vec vec, int *__ierr ){
*__ierr = VecAssemblyBegin(
	(Vec)PetscToPointer( (vec) ));
}
void vecassemblyend_(Vec vec, int *__ierr ){
*__ierr = VecAssemblyEnd(
	(Vec)PetscToPointer( (vec) ));
}
void vecgetsize_(Vec x,int *size, int *__ierr ){
*__ierr = VecGetSize(
	(Vec)PetscToPointer( (x) ),size);
}
void vecgetlocalsize_(Vec x,int *size, int *__ierr ){
*__ierr = VecGetLocalSize(
	(Vec)PetscToPointer( (x) ),size);
}
void vecgetownershiprange_(Vec x,int *low,int *high, int *__ierr ){
*__ierr = VecGetOwnershipRange(
	(Vec)PetscToPointer( (x) ),low,high);
}
void vecsetoption_(Vec x,VecOption *op, int *__ierr ){
*__ierr = VecSetOption(
	(Vec)PetscToPointer( (x) ),*op);
}
#if defined(__cplusplus)
}
#endif
