!
!    "$Id: ex19.F,v 1.31 1998/04/15 18:00:32 balay Exp $";
!
#include "include/finclude/petsc.h"
#include "include/finclude/vec.h"
!
!  This example demonstrates basic use of the PETSc Fortran interface
!  to vectors.
!
       integer          n, ierr,flg
       Scalar           one, two, three, dot
       double precision norm,rdot
       Vec              x,y,w

       n     = 20
       one   = 1.0
       two   = 2.0
       three = 3.0

       call PetscInitialize(PETSC_NULL_CHARACTER,ierr)                  
       call OptionsGetInt(PETSC_NULL_CHARACTER,'-n',n,flg,ierr)

! Create a vector, then duplicate it
       call VecCreate(PETSC_COMM_WORLD,PETSC_DECIDE,n,x,ierr)
       call VecDuplicate(x,y,ierr)
       call VecDuplicate(x,w,ierr)

       call VecSet(one,x,ierr)
       call VecSet(two,y,ierr)

       call VecDot(x,y,dot,ierr)
       rdot = PetscReal(dot)
       write(6,100) rdot
  100  format('Result of inner product ',f10.4)

       call VecScale(two,x,ierr)
       call VecNorm(x,NORM_2,norm,ierr)
       write(6,110) norm
  110  format('Result of scaling ',f10.4)

       call VecCopy(x,w,ierr)
       call VecNorm(w,NORM_2,norm,ierr)
       write(6,120) norm
  120  format('Result of copy ',f10.4)

       call VecAXPY(three,x,y,ierr)
       call VecNorm(y,NORM_2,norm,ierr)
       write(6,130) norm
  130  format('Result of axpy ',f10.4)

       call VecDestroy(x,ierr)
       call VecDestroy(y,ierr)
       call VecDestroy(w,ierr)
       call PetscFinalize(ierr)
       end

 
