/* 
 *   $Id: ad_pfs_flush.c,v 1.2 1997/09/04 20:40:03 thakur Exp $    
 *
 *   Copyright (C) 1997 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "ad_pfs.h"

void ADIOI_PFS_Flush(ADIO_File fd, int *error_code)
{
    int err, np_total, np_comm;

/* fsync is not actually needed in PFS, because it uses something
   called fast-path I/O. However, it doesn't do any harm either. */
    err = fsync(fd->fd_sys);
    *error_code = (err == 0) ? MPI_SUCCESS : MPI_ERR_UNKNOWN;

/* MPI-IO requires that after an fsync all processes must see the same
   file size. In PFS M_ASYNC mode, this doesn't automatically happen.
   Therefore, if M_ASYNC mode, temporarily change it to M_UNIX mode
   and then switch back to M_ASYNC. That updates the file size! */

    MPI_Comm_size(MPI_COMM_WORLD, &np_total);
    MPI_Comm_size(fd->comm, &np_comm);
    if ((np_total == np_comm) && (!(fd->atomicity))) {
	err = _setiomode(fd->fd_sys, M_UNIX);
	err = _setiomode(fd->fd_sys, M_ASYNC);
    }
    /* else it is M_UNIX anyway. don't do anything. */
}
