#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: admin_repository.pl,v 1.6 1998/02/11 18:11:54 rib Exp $
#
# $Log: admin_repository.pl,v $
# Revision 1.6  1998/02/11 18:11:54  rib
# fixed broken link from help/quickstart.html -> help/quickguide.html
#
# Revision 1.5  1998/01/23 20:39:19  rib
# *** empty log message ***
#
# Revision 1.4  1998/01/23 20:20:59  rib
# added another link to the quickstart guide
#
# Revision 1.3  1998/01/23 20:15:28  rib
# added more pointers to the RIB Quickstart guide
#
# Revision 1.2  1998/01/22 02:50:06  rib
# added the upload and mirroring feature to RIB.  This required
# the addition of several new scripts and the modification of
# admin_repository.
#
# also, removed any use of <a target=whatever href=...>
# from the RIB scripts because this was working out very
# well.
#
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.2  1997/05/26 13:31:13  mcmahan
# changed $cgipath to use the admin/ subdirectory because of the problems
# with access control
#
# Revision 1.1  1997/05/06 18:15:01  jhorner
# Initial revision
#

use RIB::Util ();
use RIB::ConfigParser ();

my $util = RIB::Util->new();
$util->PrintHeader();

my $back_to_top = $util->BackToTop();

#############################################################################

my $repository = $util->GetRepoName();
unless ($repository) {
  $util->ErrorMessage("Couldn't derive repository name "
                    . "from current directory");
}

my $RIBDIR = $util->GetRibDir();
my $RIBURL = $util->GetRibUrl();
my $urlpath = "$RIBURL/repositories/$repository";
my $cgipath = "$RIBURL/cgi-bin/admin/repositories/$repository";
my $filepath = "$RIBDIR/repositories/$repository";

my $config = RIB::ConfigParser->new();
$config->load_config($filepath . "/conf/BIDM.conf");
my @classes = sort $config->Classes();

print <<"EOF";
<head>
    <title>Administrate repository named &quot;$repository&quot;
    </title>
</head>
<body bgcolor=\"#FFFFF0\"> 
<center><h1>Administrate repository named &quot;$repository&quot;</h1>
</center>
<p>
$back_to_top
<p>
<a href=\"$RIBURL/help/help.html\">RIB User's Guide</a>&nbsp;&nbsp;&nbsp;
<a href=\"$RIBURL/help/quickguide.html\">RIB Quickstart Guide</a>
<p>
<center>
<table border cellpadding=10>

<!--CONFIGURE REPOSITORY-->

<tr bgcolor=\"#FFFFFF\">
    <td align=center colspan=\"6\">
    <strong>Configure This Repository</strong>
    [<i><a href=\"$RIBURL/help/help.html#configure_repository\">
    <font size=\"-1\">help</font></a></i>]
    <p>
    <font size=\"-1\">
    <a href=\"$RIBURL/help/help.html#configure_access_control\">
    Help on configuring access control</a></font>
</tr>

<!--VIEW CURRENT CONFIG OR DOMAINS FILES-->

<tr bgcolor=\"#FFFFFF\">
    <td colspan=3><a href=\"$RIBURL/repositories/$repository/conf/BIDM.conf\">
	View</a> or 
	<a href=\"$cgipath/install_file.pl?filetype=config\">
	Edit</a> current Configuration file
    </td>
    <td colspan=3>
	<a href=\"$RIBURL/repositories/$repository/conf/domains.html\">
       	View</a> or
	<a href=\"$cgipath/install_file.pl?filetype=domains\">
	Edit</a> current Domains file
    </td>
</tr>

<!--INSTALL NEW CONFIG OR DESC FIlE-->

<tr bgcolor=\"#FFFFFF\">
    <td valign=top colspan=3>Install a new Configuration file :
    <ul>
    <li><a href=\"$cgipath/install_file.pl?filetype=config&amp;url=$RIBDIR/conf/Simple.conf\">Simple</a> (default)
    <li><a href=\"$cgipath/install_file.pl?filetype=config&amp;url=$RIBDIR/conf/FullBIDM.conf\">Full BIDM</a>
    <li><a href=\"$cgipath/install_file.pl?filetype=config&amp;url=$RIBDIR/conf/NHSE.conf\">NHSE version of BIDM</a>
    <li><a href=\"$cgipath/install_file.pl?filetype=config\">Enter a url for your own version</a>
    </ul>
</td>

<td valign=top colspan=3> Install a new Domains file :
    <ul>
    <li><a href=\"$cgipath/install_file.pl?filetype=domains&amp;url=$RIBDIR/conf/NHSEdomains.html\">NHSE domains</a> (default)
    <li><a href=\"$cgipath/install_file.pl?filetype=domains\">Enter a url for your own version</a>
    </ul>
</td>
</tr>

<!--SPACING-->

<tr bgcolor=\"#FFFFF0\"><td colspan=6 align=center><br><br></td></tr>

<!--OBJECT MANAGEMENT-->

<tr bgcolor=\"#FFFFFF\">
    <td align=center colspan=6>
    <strong>Create Asset Descriptions</strong>
    [<i><a href=\"$RIBURL/help/help.html#create_asset\">
    <font size=\"-1\">help</font></a></i>]
    [<i><a href=\"$RIBURL/help/quickguide.html\">
    <font size=\"-1\">quickstart guide</font></a></i>]
    </td>
</tr>
<tr bgcolor=\"#FFFFFF\">
    <td colspan=1 align=center><i>Class Name</i></td>
    <td colspan=5 align=center><i>Action</i></td>
EOF

my $class;
foreach $class (@classes) {
  next if $class eq 'RigObject';
  print <<"EOF";
<tr bgcolor=\"#FFFFFF\">
    <td align=left>$class
    </td>
    <td align=center>
	<a href=\"$cgipath/browse_objects.pl?class=$class\">Browse</a>
    </td>
    <td align=center>
	<a href=\"$cgipath/create_object.pl?class=$class\">Create</a>
    </td>
    <td align=center>
	<a href=\"$cgipath/edit_object.pl?class=$class\">Edit</a>
    </td>
    <td align=center>
	<a href=\"$cgipath/delete_object.pl?class=$class\">Delete</a>
    </td>
    <td align=center>
	<a href=\"$cgipath/create_object_choices.pl?class=$class&amp;capture=yes\">Import</a>
    </td>
</tr>
EOF
}

print <<"EOF";

<!--SPACING-->

<tr bgcolor=\"#FFFFF0\"><td colspan=6 align=center><br><br></td></tr>

<!--SOFTWARE CATALOG-->

<tr bgcolor=\"#FFFFFF\">
    <td colspan=6 align=center><strong>HTML Software Catalog</strong>
    [<i> <a href=\"$RIBURL/help/help.html#software_catalog\">
    <font size=\"-1\">help</font></a></i>]
    </td>
</tr>

<!--CREATE-->

<tr bgcolor=\"#FFFFFF\">
    <td align=center colspan=3><a href=\"generate_catalog.pl\">
EOF
if (-f $filepath . "/catalog/index.html") {
  print "Regenerate ";
} else {
  print "Generate ";
}
print <<"EOF";
    Software Catalog</a>
    </td>

<!--VIEW-->

    <td align=center colspan=3>
EOF
if (-f $filepath . "/catalog/index.html") {
  print <<"EOF";
    <a href=\"$RIBURL/repositories/$repository/catalog/index.html\">
    View Current Software Catalog</a>
EOF
} else {
  print "View Current Software Catalog\n";
}
print <<"EOF";
    </td>
</tr>

<!--VIEW/INSTALL HEADER/FOOTER-->

<tr bgcolor=\"#FFFFFF\">
    <td align=center colspan=3><i>Headers</i></td>
    <td align=center colspan=3><i>Footers</i></td>
</tr>
<tr bgcolor=\"#FFFFFF\">
    <td align=left colspan=3><br>
    <a href=\"install_file.pl?filetype=main.header\">Install, Edit,</a>
    or <a href=\"$urlpath/conf/main.header\">View</a> Catalog header<br><br>
EOF
my $footers;
# loop over classes once. We'll print out the header stuff, but
# cache the footer stuff and print it out after the loop.
foreach ( @classes ){
    next if $_ eq "RigObject";
    print "<a href=\"install_file.pl?filetype=${_}.header\">Install, Edit,</a>";
    if (-f $filepath . "/conf/${_}.header") {
	print " or <a href=\"$urlpath/conf/${_}.header\">View</a> ${_} header<br><br>\n";
    } else {
	print " or View ${_} header<br><br>\n";
    }
    $footers .= "<a href=\"install_file.pl?filetype=${_}.footer\">Install, Edit,</a>\n";
    if (-f $filepath . "/conf/${_}.footer") {
	$footers .= " or <a href=\"$urlpath/conf/${_}.footer\">View</a> ${_} footer<br><br>\n";
    } else {
	$footers .= " or View ${_} footer<br><br>\n";
    }
}
print <<"EOF";
    </td>
    <td align=left colspan=3><br>
	<a href=\"install_file.pl?filetype=main.footer\">Install, Edit,</a>
	or <a href=\"$urlpath/conf/main.footer\">View</a> Catalog footer<br><br>
	$footers
    </td>
</tr>

<!--SPACING-->

<tr bgcolor=\"#FFFFF0\"><td colspan=6 align=center><br><br></td></tr>

<!--INTEROPERATE-->

<tr bgcolor=\"#FFFFFF\">
    <td colspan=6 align=center>
     <strong>Interoperate With Another Repository</strong>
     [<i>
      <a href=\"$RIBURL/help/help.html#repository_interoperation\">
      <font size=\"-1\">help</font></a>
     </i>]
    </td>
</tr>
<tr bgcolor=\"#FFFFFF\">
    <td colspan=6 align=left><ul>
    <li><a href=\"add_nonlocal_link.pl?type=single\">
	Add a link to an Asset in a foreign repository</a>
    <li><a href=\"add_nonlocal_link.pl?type=list\">
	Add a collection of links to Assets in a foreign repository</a>
    <li><a href=\"delete_nonlocal_link.pl\">
	Delete a link to an Asset in a foreign repository</a>
    <li><a href=\"check_nonlocal_links.pl\">
	Check to see if Assets linked to by this repository have changed</a>
    <li><a href=\"$RIBURL/cgi-bin/pub/list_local_links.pl?repository=$repository\">List urls for Assets in this repository</a>
    <li><a href=\"$RIBURL/cgi-bin/pub/list_nonlocal_links.pl?repository=$repository\">List urls for Assets linked to by this repository</a>
    <li><a href=\"view_nonlocal_links.pl\">View catalog entries for Assets linked to by this repository</a>
    </ul>
    </td>
</tr>

<!--SPACING-->

<tr bgcolor=\"#FFFFF0\"><td colspan=6 align=center><br><br></td></tr>

<!--MANAGE FILES-->

<tr bgcolor=\"#FFFFFF\">
    <td colspan=6 align=center>
     <strong>Manage software files for this repository</strong>
     [<i>
      <a href=\"$RIBURL/help/help.html#managing_software_files\">
      <font size=\"-1\">help</font></a>
     </i>]
    </td>
</tr>
<tr bgcolor=\"#FFFFFF\">
    <td colspan=6 align=left><ul>
    <li><a href=\"manage_software_files.pl\">Manage software files for this repository</a>
    <li><a href=\"check_disk_space.pl\">Check disk space available for this repository</a>
    </ul>
    </td>
</tr>
</table>
</center>

$back_to_top
EOF
exit;
