#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: create_object_choices.pl,v 1.2 1998/01/22 02:50:09 rib Exp $
#
# $Log: create_object_choices.pl,v $
# Revision 1.2  1998/01/22 02:50:09  rib
# added the upload and mirroring feature to RIB.  This required
# the addition of several new scripts and the modification of
# admin_repository.
#
# also, removed any use of <a target=whatever href=...>
# from the RIB scripts because this was working out very
# well.
#
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.1  1997/05/06 18:16:02  jhorner
# Initial revision
#

use strict;
use RIB::Util ();
use RIB::ConfigParser ();

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
$util->PrintHeader();

my $repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("repository was not specifed in your input.");
} elsif (!$in{class}) {
  $util->ErrorMessage("class was not specifed in your input.");
}

my $filepath = $util->GetRibDir() . "/repositories/" . $repository;
my $urlpath  = $util->GetRibUrl() . "/repositories/" . $repository;

my $back_to_top = $util->BackToTop($repository);

#############################################################################

print "<head>";
print "<title>$in{class} ";
print "creation for &quot;$repository&quot;</title>\n";
print "</head>\n";
print "<body bgcolor=#FFFFF0>\n";
print "<center>\n";
print "<h1>$in{class} creation for ";
print "&quot;$repository&quot;</h1>\n";
print "</center>\n";
print "<p><hr><p>\n";

# Come here if user wants to link url to this repository
# 
# Only a head request is performed, and the only thing 
# added to the nonlocal file is the url and last-modified
# date, if defined.
if ($in{url}) {
  $in{url} =~ s/^\s*(\S+).*/$1/; # get rid of whitespace

  # Start of critical section for .nonlocal file
  unless($util->InitNonLocal($repository)){
	$util->ErrorMessage("Couldn't add the url, Please contact "
			. "your RIB administrator");
  }

  if ($util->NonLocalLink($in{url})) {
    print "<strong>Results</strong><p>\n";
    print "The url<dl><dd>$in{url}</dl>was already in this repository's\n";
    print "list of foreign $in{class} links so it was not added again.\n";
  } elsif (!$util->AddNonLocalLink($in{url})){
    print "<strong>Results</strong><p>\n";
    print "The url<dl><dd>$in{url}</dl>does not appear to be a ";
    print "valid url.  Therefore it was not added to the\n";
    print "list of foreign $in{class} links.<p>\n";
    print "<form method=post action=create_object_choices.pl>\n";
    print "If you would like to try your submission again, then ";
    print "please enter the url of the $in{class} that you wish to ";
    print "link to from this repository:<p>\n";
    print "URL : <input name=url size=85><br>\n";
    print "<input type=hidden name=class value=$in{class}>\n";
    print "<input type=submit value=Submit>\n";
    print "</form>\n";
  } else {
    print "<strong>Success</strong><p>\n";
    print "The url<dl><dd>$in{url}</dl>has been added to this repository's\n";
    print "list of foreign $in{class} links.\n";
  }
  $util->CommitNonLocal();
  # End of critical section for .nonlocal file
  print $back_to_top;
  print "<p><a href=create_object_choices.pl?",
        "class=$in{class}&capture=no>";
  print "Add another link to this repository</a>\n";
  print "<p><a href=delete_nonlocal_link.pl>";
  print "Delete a link from this repository</a>\n";
  exit;
} elsif ($in{capture}) {
  if ($in{capture} eq 'yes') {
    # this form allows you to jump into the edit_object.pl
    # script at the point where the name of the file to be edited
    # has been chosen
    print "<form method=post action=edit_object.pl>\n";
    print "Please enter the url of the $in{class} that you wish to ";
    print "import into this repository:<p>\n";
    print "URL : <input name=filename size=85><br>\n";
    print "<input type=hidden name=class value=$in{class}>\n";
    print "<input type=hidden name=getfromfile value=1>\n";
    print "<input type=submit value=Submit>\n";
    print "</form>\n";
  }
  elsif ($in{capture} eq 'no') {
    print "<form method=post action=create_object_choices.pl>\n";
    print "Please enter the url of the $in{class} that you wish to ";
    print "link to from this repository:<p>\n";
    print "URL : <input name=url size=85><br>\n";
    print "<input type=hidden name=class value=$in{class}>\n";
    print "<input type=submit value=Submit>\n";
    print "</form>\n";
  }
  print $back_to_top;
  exit;
} else {
  print "[<i><a href=", $util->GetRibUrl(),
         "/help/help.html#create_options>";
  print "help</a> on using this page</i>]\n<p>\n";
  print "To create a new $in{class} file for this repository, please ";
  print "choose between the following options:<p>\n";
  print "<ul>\n";
  print "<li><a href=create_object.pl?";
  print "class=$in{class}>";
  print "Create a new $in{class}</a>";
  print "<li><a href=create_object_choices.pl?";
  print "class=$in{class}&capture=yes>";
  print "Import a(n)";
  print " $in{class} from a foreign repository</a>\n";
  print "</ul>\n";
  print $back_to_top;
  exit;
}
