#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.

use strict;
use RIB::Util ();
$|=1; # unbuffer

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
$util->PrintHeader();

my $repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("repository was not specifed in your input.");
}

my $filepath = $util->GetRibDir() . "/repositories/" . $repository;
my $urlpath  = $util->GetRibUrl() . "/repositories/" . $repository;

my $back_to_top = $util->BackToTop($repository);


unless (-f "$filepath/catalog/.nonlocal" or -s "$filepath/catalog/.nonlocal") {
print <<"EOF";
<head><title>No Links</title></head><body bgcolor=\"#FFFFF0\">
<center><h1>Non-local links in $repository</h1></center>
This repository's catalog contains no links to foreign Assets.
$back_to_top</body>
EOF
exit;
}

unless ($util->InitNonLocal($repository)) {
   $util->ErrorMessage('Access to the links is currently locked.'
       .' Please try pressing the Reload button in your web client.'
       .' If this message persists, contact your RIB administrator<br>');
}


print <<"EOF";
<head><title>Catalog entries for Non-local links in $repository</title>
</head><body bgcolor=#FFFFF0>
<center><h1>Catalog entries for Non-local links in $repository</h1>
</center><p><hr><p><dl>
EOF

my @list_o_links;
my $link;
@list_o_links = $util->NonLocalLink();
foreach $link ( sort {$a->{URL} cmp $b->{URL}} @list_o_links ){
  print <<"EOF";
<dt><strong>Catalog Entry :</strong>
<a href=\"$urlpath/catalog/Asset/$link->{FILE}\">$link->{FILE}</a>
<dd><strong><i>linked to </i>:</strong>
<a href=\"$link->{URL}\">$link->{URL}</a>
EOF
}
print '</dl>',$back_to_top;

$util->CommitNonLocal();
