#!/usr/local/bin/perl -w
require "Util.pm";
use strict;
use integer;
use FileHandle; 
select (STDERR); $| = 1; # no output buffering
select (STDOUT); $| = 1; # no output buffering
 
open(STDERR,">&STDOUT") || die ("Cannot dup stdout.".
        " Please contact your RIB administrator.");

#Util->PrintHeader();

unless (@ARGV){
    Util->HtmlEmbeddedCroak("This script <strong>MUST</strong>".
	" be called with one argument. Please contact the <strong>RIB".
	" </strong>maintainers.");
}

my $ipath = Util->GetRibDir() . "/repositories/" . $ARGV[0] . 
    "/index/" . $ARGV[0] ;
my $dpath = Util->GetRibDir() . "/repositories/" . $ARGV[0] .
    "/catalog/";

unless (opendir (DIR,"$dpath")) {
    Util->HtmlEmbeddedCroak("Couldn't open the directory "
                   . "$dpath."
                   . "<p>Reason: $!<p>\n");
}
my @files;
while($_ = readdir(DIR)){
    if ($_ ne "." && $_ ne ".." && $_ ne "index.html"){
	push @files, $dpath . $_ ;
    }
} 

my $files = join(' ',@files);
print "<pre>";
if (system("./Iindex -d $ipath -t HTML $files")){
    print "</pre>";
    Util->HtmlEmbeddedCroak("Could not run Iindex");
}
print "</pre>";
#open(IINDEX,"./Iindex -d $ipath -t HTML $files 2>&1 |") ||
#    Util->HtmlEmbeddedCroak("Could not run Iindex");

#while (<IINDEX>){
#    print "$_<br>\n";
#}
