!
!  $Id: petsc.h,v 1.75 1998/04/29 18:15:45 balay Exp $;
!
!
!
!


!
!     Flags
!
      integer   PETSC_TRUE, PETSC_FALSE, PETSC_DECIDE
      integer   PETSC_DEFAULT_INTEGER,PETSC_DETERMINE
      integer   PETSC_FP_TRAP_OFF, PETSC_FP_TRAP_ON

      parameter (PETSC_TRUE = 1, PETSC_FALSE = 0, PETSC_DECIDE = -1)
      parameter (PETSC_DEFAULT_INTEGER = -2,PETSC_DETERMINE = -1)
      parameter (PETSC_FP_TRAP_OFF = 0, PETSC_FP_TRAP_ON = 1) 


      double precision PETSC_DEFAULT_DOUBLE_PRECISION

      parameter (PETSC_DEFAULT_DOUBLE_PRECISION=-2.0d0)

!
!     Default Viewers
!
      integer VIEWER_STDOUT_SELF, VIEWER_STDERR_SELF
      integer VIEWER_STDOUT_WORLD, VIEWER_DRAWX_WORLD
      integer VIEWER_DRAWX_WORLD_0,VIEWER_DRAWX_WORLD_1
      integer VIEWER_DRAWX_WORLD_2,VIEWER_DRAWX_SELF
      integer VIEWER_MATLAB_WORLD
!
!     The numbers used below should match those in 
!     src/fortran/custom/zpetsc.h
!
      parameter (VIEWER_DRAWX_WORLD_0 = -4) 
      parameter (VIEWER_DRAWX_WORLD_1 = -5)
      parameter (VIEWER_DRAWX_WORLD_2 = -6)
      parameter (VIEWER_DRAWX_SELF = -7)
      parameter (VIEWER_MATLAB_WORLD = -8)
      parameter (VIEWER_DRAWX_WORLD = VIEWER_DRAWX_WORLD_0)


!
!     PETSc DataTypes
!
      integer PETSC_INT, PETSC_DOUBLE, PETSC_SHORT, PETSC_FLOAT
      integer PETSC_COMPLEX, PETSC_CHAR, PETSC_LOGICAL

      parameter (PETSC_INT=0, PETSC_DOUBLE=1, PETSC_SHORT=2)
      parameter (PETSC_FLOAT=3, PETSC_COMPLEX=4, PETSC_CHAR=5)
      parameter (PETSC_LOGICAL=6)


!
! PETSc world communicator
!
      integer PETSC_COMM_WORLD, PETSC_COMM_SELF

!
!     Macros for error checking
!
!
!
!
! ------------------------------------------------------------------------
!    constants and functions for working with single and double precision
!    floating point numbers as well as complex and integers.
!
!
!     Representation of complex i
!
      double complex PETSC_i
      parameter (PETSC_i = (0.0d0,1.0d0))
!
!
!
! F90 uses real(), conjg() when KIND parameter is used.
!

!
!     Basic constants
! 
      double precision PETSC_PI,PETSC_DEGREES_TO_RADIANS
      double precision PETSC_MAX,PETSC_MIN

      parameter (PETSC_PI = 3.14159265358979323846264d0)
      parameter (PETSC_DEGREES_TO_RADIANS = 0.01745329251994d0)
      parameter (PETSC_MAX = 1.d300, PETSC_MIN = -1.d300)

! ----------------------------------------------------------------------------
!    This part requires some info from the math part of petsc.h 
!    including certain datatype Declarations.

!
!     Fortran Null
!
      character*(80)   PETSC_NULL_CHARACTER
      integer          PETSC_NULL_INTEGER
      double precision PETSC_NULL_DOUBLE
!
!     Declare PETSC_NULL_OBJECT
!
!
!      A PETSC_NULL_FUNCTION pointer
!
      external PETSC_NULL_FUNCTION
      double precision           PETSC_NULL_SCALAR
!
!     Common Block to store some of the PETSc constants.
!     which can be set - only at runtime.
!
!
!     A string should be in a different common block
!  
      common /petscfortran1/ PETSC_NULL_CHARACTER
      common /petscfortran2/ PETSC_NULL_INTEGER
      common /petscfortran3/ PETSC_NULL_SCALAR
      common /petscfortran4/ PETSC_NULL_DOUBLE
      common /petscfortran5/ VIEWER_STDOUT_SELF,VIEWER_STDERR_SELF
      common /petscfortran6/ VIEWER_STDOUT_WORLD
      common /petscfortran7/ PETSC_COMM_WORLD,PETSC_COMM_SELF
!
!     PLogdouble precision variables are used to contain double precision numbers
!     that are not used in the numerical computations, but rather in logging,
!     timing etc.
!



!     End PART 2 of petsc.h
! ----------------------------------------------------------------------------
!   You will have to adjust this line for your site
      include 'mpif.h'
