#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: genmpidf.c,v 1.20 1998/03/12 23:22:10 bsmith Exp $";
#endif

/*
   Implements general sequential discrete function utilities.
*/
#include "src/dfvec/dfvimpl.h" 
#include "src/vec/vecimpl.h"

#undef __FUNC__  
#define __FUNC__ "DFVecAssembleFullVector_MPIGeneral"
int DFVecAssembleFullVector_MPIGeneral(Vec *vsub,DFVec v)
{
  int        ierr, i, gsize, gsub, lsub, lsz, gsz, nc, lsize;
  VecScatter vsctx;
  IS         is, newis;
  DF         df;

  ierr = DFVecGetDFShell(v,&df); CHKERRQ(ierr);
  nc   = df->nc;
  ierr = VecGetSize(v,&gsize); CHKERRQ(ierr);
  ierr = VecGetLocalSize(v,&lsize); CHKERRQ(ierr);
  ierr = VecGetSize(vsub[0],&gsub); CHKERRQ(ierr);
  ierr = VecGetLocalSize(vsub[0],&lsub); CHKERRQ(ierr);
  for (i=0; i<nc; i++) {
    ierr = VecGetSize(vsub[i],&gsz); CHKERRQ(ierr);
    if (gsz != gsub) SETERRQ(PETSC_ERR_ARG_SIZ,0,"All global subvecs must be same size");
    ierr = VecGetLocalSize(vsub[i],&lsz); CHKERRQ(ierr);
    if (lsz != lsub) SETERRQ(PETSC_ERR_ARG_SIZ,0,"All local subvecs must be same size");
  }
  if (gsz*nc != gsize) SETERRQ(PETSC_ERR_ARG_SIZ,0,"Incompatible subvecs with global vec");
  if (lsz*nc != lsize) SETERRQ(PETSC_ERR_ARG_SIZ,0,"Incompatible subvecs with local vec");

  if (nc == 1) {
    ierr = VecCopy(vsub[0],v); CHKERRQ(ierr);
  } 
  else {
    if (df->order != ORDER_1 && df->order != ORDER_2) {
      SETERRQ(PETSC_ERR_SUP,0,"Ordering not supported.");
    }
    ierr = ISCreateStride(df->comm,gsub,0,1,&newis); CHKERRQ(ierr);
    for (i=0; i<nc; i++) {
      if (df->order == ORDER_1) {
        ierr = ISCreateStride(df->comm,gsub,i,nc,&is); CHKERRQ(ierr);
      }
      else if (df->order == ORDER_2) {
        ierr = ISCreateStride(df->comm,gsub,i*gsub,1,&is); CHKERRQ(ierr);
      }
      ierr = VecScatterCreate(vsub[i],newis,v,is,&vsctx); CHKERRQ(ierr);
      ierr = VecScatterBegin(vsub[i],v,INSERT_VALUES,SCATTER_FORWARD,vsctx); CHKERRQ(ierr);
      ierr = VecScatterEnd(vsub[i],v,INSERT_VALUES,SCATTER_FORWARD,vsctx); CHKERRQ(ierr);
      ierr = VecScatterDestroy(vsctx); CHKERRQ(ierr);
      ierr = ISDestroy(is); CHKERRQ(ierr);
    }
  ierr = ISDestroy(newis); CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
}

static struct _DFOps DFMPIGeneralOps = {0,0,DFVecAssembleFullVector_MPIGeneral,0,0};

#undef __FUNC__  
#define __FUNC__ "DFSetMPIGeneralOps_Private"
int DFSetMPIGeneralOps_Private(DF v)
{ 
  PetscMemcpy(v->ops,&DFMPIGeneralOps,sizeof(DFMPIGeneralOps));
  PetscFunctionReturn(0);
}
