#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: ex4.c,v 1.27 1997/11/28 16:20:59 bsmith Exp $";
#endif

static char help[] = "Demonstrates drawing contours.\n";

#include "petsc.h"
#include "vec.h"
#include <math.h>

int main(int argc,char **argv)
{
  Draw   draw, draw2;
  int    ierr, x = 0, y = 0, width = 300, height = 300, m = 16, n = 11;
  int    i, start, end, flg;
  double *xc, *yc, h;
  Vec    v;
  Scalar value;
 
  PetscInitialize(&argc,&argv,(char*)0,help);
  ierr = OptionsGetInt(PETSC_NULL,"-m",&m,&flg); CHKERRA(ierr);
  ierr = OptionsGetInt(PETSC_NULL,"-n",&n,&flg); CHKERRA(ierr);

  /* Create and assemble vector */
  ierr = VecCreate(PETSC_COMM_WORLD,PETSC_DECIDE,n*m,&v); CHKERRA(ierr);
  ierr = VecGetOwnershipRange(v,&start,&end); CHKERRA(ierr);
  for ( i=start; i<end; i++ ) {
    value = 32.0 + (double) i;
    ierr = VecSetValues(v,1,&i,&value,INSERT_VALUES); CHKERRA(ierr);
  }
  ierr = VecAssemblyBegin(v); CHKERRA(ierr);
  ierr = VecAssemblyEnd(v); CHKERRA(ierr);

  /* Draw contour, using default coordinates (uniform [0,1] spacing) */
  ierr = DrawOpenX(PETSC_COMM_WORLD,0,"Contour with default coordinates",
         x,y,width,height,&draw); CHKERRA(ierr);
  ierr = DrawSetViewPort(draw,.1,.1,.9,.9); CHKERRA(ierr);
  ierr = DrawTensorContour(draw,m,n,0,0,v); CHKERRA(ierr);
  ierr = DrawSynchronizedFlush(draw); CHKERRA(ierr);

  /* Draw contour, setting (different) coordinates explicitly */
  xc = (double *) PetscMalloc( m*sizeof(double) ); CHKPTRA(xc);
  yc = (double *) PetscMalloc( n*sizeof(double) ); CHKPTRA(yc);
  h = 1.0/(m-1);
  for ( i=0; i<m; i++ ) xc[i] = h*i;
  h = 1.0/(n-1);
  for ( i=0; i<n; i++ ) yc[i] = h*i*i;

  y += 320;
  ierr = DrawOpenX(PETSC_COMM_WORLD,0,"Contour with user-defined coordinates",
         x,y,width,height,&draw2); CHKERRA(ierr);
  ierr = DrawSetViewPort(draw2,.1,.1,.9,.9); CHKERRA(ierr);
  ierr = DrawSetCoordinates(draw2,0.0,0.0,1.0,(double)(n-1));CHKERRA(ierr);
  ierr = DrawTensorContour(draw2,m,n,xc,yc,v); CHKERRA(ierr);
  ierr = DrawSynchronizedFlush(draw2); CHKERRA(ierr);

  /* Free work space */
  PetscFree(xc); PetscFree(yc);
  ierr = DrawDestroy(draw); CHKERRA(ierr);
  ierr = DrawDestroy(draw2); CHKERRA(ierr);
  ierr = VecDestroy(v); CHKERRA(ierr);
  PetscFinalize();
  return 0;
}
 
