#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: vopen.c,v 1.6 1997/07/09 21:36:17 balay Exp bsmith $";
#endif
/* 
   This file contains routines to write VRML to a file.
   This consists of a number of routines that set the various
   fields, which is passed to 
   all of these routines.
*/

#include "src/draw/impls/vrml/vrmlimpl.h"

/*
    Actually display a window at [x,y] with sizes (w,h)
    If w and/or h are 0, use the sizes in the fields of XiWin
    (which may have been set by, for example, XiSetWindowSize)
*/
#undef __FUNC__  
#define __FUNC__ "XiDisplayWindow"
int XiDisplayWindow( Draw_X* XiWin, char *label, int x, int y,
                     int w,int h,PixVal backgnd_pixel )
{
  unsigned int            wavail, havail;
  XSizeHints              size_hints;
  XWindowAttributes       in_window_attributes;
  XSetWindowAttributes    window_attributes;
  int                     depth, border_width;
  unsigned long           wmask;

  PetscFunctionBegin;
  /* get the available widths */
  wavail              = DisplayWidth(  XiWin->disp, XiWin->screen );
  havail              = DisplayHeight( XiWin->disp, XiWin->screen );
  if (w <= 0 || h <= 0) PetscFunctionReturn(2);
  if (w > wavail) w    = wavail;
  if (h > havail)  h   = havail;

  /* changed the next line from xtools version */
  border_width   = 0;
  if (x < 0) x   = 0;
  if (y < 0) y   = 0;
  x   = (x + w > wavail) ? wavail - w : x;
  y   = (y + h > havail) ? havail - h : y;

  /* We need XCreateWindow since we may need an visual other than
   the default one */
  XGetWindowAttributes( XiWin->disp, RootWindow(XiWin->disp,XiWin->screen),
                        &in_window_attributes );
  window_attributes.background_pixmap     = None;
  window_attributes.background_pixel      = backgnd_pixel;
  /* No border for now */
  window_attributes.border_pixmap         = None;
  /* 
  window_attributes.border_pixel          = border_pixel; 
  */
  window_attributes.bit_gravity           = in_window_attributes.bit_gravity;
  window_attributes.win_gravity           = in_window_attributes.win_gravity;
  window_attributes.backing_store         = 1;
  window_attributes.backing_pixel         = backgnd_pixel;
  window_attributes.save_under            = 1;
  window_attributes.event_mask            = 0;
  window_attributes.do_not_propagate_mask = 0;
  window_attributes.override_redirect     = 0;
  window_attributes.colormap              = XiWin->cmap;
  window_attributes.cursor                = None; /* use Parent's cursor */ 
  wmask   = CWBackPixmap | CWBackPixel | CWBorderPixmap | CWBitGravity |
            CWWinGravity | CWBackingStore |CWBackingPixel|CWOverrideRedirect |
            CWSaveUnder  | CWEventMask    | CWDontPropagate |
            CWCursor     | CWColormap ;
  /* depth should really be the depth of the visual in use */
  depth       = DefaultDepth( XiWin->disp, XiWin->screen );
  XiWin->win  = XCreateWindow( XiWin->disp, 
			     RootWindow(XiWin->disp,XiWin->screen),
                             x, y, w, h, border_width,
                             depth, InputOutput, XiWin->vis,
                             wmask, &window_attributes );

  if (!XiWin->win)  PetscFunctionReturn(2);

  /* set window manager hints */
  {
    XWMHints      wm_hints;
    XClassHint    class_hints;
    XTextProperty windowname,iconname;
    
    XStringListToTextProperty(&label,1,&windowname);
    XStringListToTextProperty(&label,1,&iconname);
    
    wm_hints.initial_state  = NormalState;
    wm_hints.input          = True;
    wm_hints.flags          = StateHint|InputHint;
 
    class_hints.res_name    = 0;
    class_hints.res_class   = "BaseClass"; /* this is nonsense */

    size_hints.x            = x;
    size_hints.y            = y;
    size_hints.min_width    = 4*border_width;
    size_hints.min_height   = 4*border_width;
    size_hints.width        = w;
    size_hints.height       = h;
    size_hints.flags        = USPosition | USSize | PMinSize;
 
    XSetWMProperties(XiWin->disp,XiWin->win,&windowname,&iconname,
                     0,0,&size_hints,&wm_hints,&class_hints);
  }
  /* make the window visible */
  XSelectInput( XiWin->disp, XiWin->win, ExposureMask | StructureNotifyMask );
  XMapWindow( XiWin->disp, XiWin->win );

  /* some window systems are cruel and interfere with the placement of
     windows.  We wait here for the window to be created or to die */
  if (Xi_wait_map( XiWin)){
    XiWin->win    = (Window)0;
    PetscFunctionReturn(1);
  }
  /* Initial values for the upper left corner */
  XiWin->x = 0;
  XiWin->y = 0;
  PetscFunctionReturn(0);
}

#undef __FUNC__  
#define __FUNC__ "XiQuickWindow"
int XiQuickWindow(Draw_X* w,char* host,char* name,int x,int y,
                   int nx,int ny,int nc )
{
  int ierr;

  if (XiOpenDisplay( w, host )) {
    fprintf(stderr,"Trying to open display: %s\n",host);
    SETERRQ(1,0,"Could not open display: make sure your DISPLAY variable\n\
    is set, or you use the -display name option and xhost + has been\n\
    run on your displaying machine.\n" );
  }
  if (XiSetVisual( w, 1, (Colormap)0, nc )) {
    PetscFunctionReturn(1);
  }
  if (XiDisplayWindow( w, name, x, y, nx, ny, (PixVal)0 )) {
    PetscFunctionReturn(1);
  }
  XiSetGC( w, w->cmapping[1] );
  XiSetPixVal(w, w->background );
  ierr = XiUniformHues(w,nc-36); CHKERRQ(ierr);
  ierr = XiFontFixed( w,6, 10,&w->font ); CHKERRQ(ierr);
  /* clear the window */
  XFillRectangle(w->disp,w->win,w->gc.set,0,0,w->w,w->h);
  PetscFunctionReturn(0);
}

/* 
   A version from an already defined window 
*/
#undef __FUNC__  
#define __FUNC__ "XiQuickWindowFromWindow"
int XiQuickWindowFromWindow(Draw_X* w,char *host,Window win,int nc)
{
  Window       root;
  int          d,ierr;
  unsigned int ud;

  if (XiOpenDisplay( w, host )) {
    SETERRQ(1,0,"Could not open display: make sure your DISPLAY variable\n\
    is set, or you use the [-display name] option and xhost + has been\n\
    run on your displaying machine.\n" );
  }
  if (XiSetVisual( w, 1, (Colormap)0, 0 )) {
    SETERRQ(1,0,"Cannot set visual in display");
  }

  w->win = win;
  XGetGeometry( w->disp, w->win, &root, &d, &d, 
	      (unsigned int *)&w->w, (unsigned int *)&w->h,&ud, &ud );
  w->x = w->y = 0;

  XiSetGC( w, w->cmapping[1] );
  XiSetPixVal(w, w->background );
  ierr = XiUniformHues(w,nc-36); CHKERRQ(ierr);
  ierr = XiFontFixed( w,6, 10,&w->font ); CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

/*
      XiSetWindowLabel - Sets new label in open window.
*/
#undef __FUNC__  
#define __FUNC__ ""
int XiSetWindowLabel(Draw_X* Xiwin, char *label )
{
  XTextProperty prop;
  XGetWMName(Xiwin->disp,Xiwin->win,&prop);
  prop.value = (unsigned char *)label; prop.nitems = (long) PetscStrlen(label);
  XSetWMName(Xiwin->disp,Xiwin->win,&prop);
  PetscFunctionReturn(0);
}

#undef __FUNC__  
#define __FUNC__ ""
int XiSetToBackground(Draw_X* XiWin )
{
  if (XiWin->gc.cur_pix != XiWin->background) { 
    XSetForeground( XiWin->disp, XiWin->gc.set, XiWin->background ); 
    XiWin->gc.cur_pix   = XiWin->background;
  }
  PetscFunctionReturn(0);
}


