!
!  "$Id: ex1f90.F,v 1.8 1998/04/15 18:02:46 balay Exp $";
!
!/*T
!    Concepts: Index sets^Manipulating a general index set;
!    Concepts: Fortran90;
!    Routines: ISCreateGeneral(); ISDestroy(); ISView(); ISGetSize()
!    Routines: ISGetIndicesF90(); ISRestoreIndicesF90()
!T*/
!    
!  Comment: Creates an index set based on a set of integers. Views that index set
!  and then destroys it.
!
!  The following include statements are required for Fortran programs
!  that use PETSc index sets:
!     petsc.h  - base PETSc routines
!     is.h     - index sets (IS objects)
!     is90.h   - to allow access to Fortran90 features of index sets
!
      implicit none

#include "finclude/petsc.h"
#include "finclude/is.h"
#include "finclude/is.h90"

      integer ierr, indices(5),rank,n
      integer, pointer :: idx(:)
      IS      is

      call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
      call MPI_Comm_rank(PETSC_COMM_WORLD,rank,ierr)

!  Create an index set with 5 entries. Each processor creates
!  its own index set with its own list of integers.
   
      indices(1) = rank + 1
      indices(2) = rank + 2 
      indices(3) = rank + 3 
      indices(4) = rank + 4 
      indices(5) = rank + 5 
      call ISCreateGeneral(PETSC_COMM_SELF,5,indices,is,ierr)

!  Print the index set to stdout

      call ISView(is,VIEWER_STDOUT_SELF,ierr)

!  Get the number of indices in the set 

      call ISGetSize(is,n,ierr)

!   Get the indices in the index set

      call ISGetIndicesF90(is,idx,ierr)

!   Now any code that needs access to the list of integers
!   has access to it here

      print*, idx

      write(6,100) rank,idx(1),idx(5)
 100  format('[',i5,'] First index = ',i5,' fifth index = ',i5)
      
!   Once we no longer need access to the indices they should 
!   returned to the system 

      call ISRestoreIndicesF90(is,idx,ierr)
  
!   All PETSc objects should be destroyed once they are 
!   no longer needed

      call ISDestroy(is,ierr)
      call PetscFinalize(ierr)
      end

 



