/*  Matrix Multiplication */

#include <stdio.h>

void printArray(matrixName, array, n)
     char *matrixName;
     int  *array;
     int  n;
{
  int i, j;

  printf("\n%s:\n\n", matrixName);

  for (i=0; i<n; i++) {
    for (j=0; j<n; j++) {
      printf(" %d ", array[n * i + j]);
    }
    printf("\n");
  }
}


int *multArrays(leftArray, rightArray, n)
     int *leftArray;
     int *rightArray;
     int n;
{
  int *resultArray, i, j, k;

  resultArray = (int *) malloc(sizeof(int)*n*n);

  for (i=0; i<n; i++) {
    for (j=0; j<n; j++) {
	resultArray[n * i + j] = 0;
	for (k=0; k<n; k++) {
	    resultArray[n * i + j] += (leftArray[n * i + k]) *
	                              (rightArray[n * k + j]);
	  }
      }
  }
  return resultArray;
}


main(argc, argv)
     int argc;
     char *argv[];
{
  int n = 2;
  int A[2][2] = {{1, 2}, {3, 4}};
  int B[2][2] = {{5, 6}, {7, 8}};
  int *C;
  char buf[80];

  printf("PROGRAM BEGIN\n");
  sprintf(buf,"Matrix A");
  printArray(buf, A, n);
  sprintf(buf,"Matrix B");
  printArray(buf, B, n);

  C = multArrays(A, B, n);
  sprintf(buf,"The Result of A times B is");
  printArray(buf, C, n);

#ifdef BTIMESA
  C = multArrays(B, A, n);
  sprintf(buf,"The Result of B times A is");
  printArray(buf, C, n);
#endif /* BTIMESA */

  printf("PROGRAM END\n");
}




