/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Keith A. Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *
 */


#include "MainWindow.h"



/****************************************************************************
*****************************************************************************/
void addTextScrollBarCallbacks(textVScroll)
     Widget textVScroll;
{
  XtAddCallback(textVScroll, XmNdragCallback, dragTextMovement, NULL);

  XtAddCallback(textVScroll, XmNincrementCallback, textMovement, 
                NULL);
  XtAddCallback(textVScroll, XmNdecrementCallback, textMovement,
                NULL);
  XtAddCallback(textVScroll, XmNvalueChangedCallback, textMovement, 
                NULL);
  XtAddCallback(textVScroll, XmNpageIncrementCallback,textMovement, 
                NULL);
  XtAddCallback(textVScroll, XmNpageDecrementCallback,textMovement, 
                NULL);
  XtAddCallback(textVScroll, XmNtoTopCallback,textMovement, 
                NULL);
  XtAddCallback(textVScroll, XmNtoBottomCallback,textMovement, 
                NULL);
}



/****************************************************************************
  This function creates and lays out the widgets for the main window.
  Several functions are called based on the logical/functional breakdown of
  the components, but the primary activity done in this function and any
  called functions is to create and manage widgets, specify their location,
  and register callback functions.
*****************************************************************************/
void buildMainInterface(mainWin)
     Widget mainWin; 
{
  Widget mainPW;

  TextSliderSize = 0;

  makeMenuBar(mainWin);
    
  mainPW = XtCreateWidget("mainPW", xmPanedWindowWidgetClass, mainWin, NULL, 
			   0);
 
  makeMainPane1(mainPW);
  makeMainPane2(mainPW);
  makeMainPane3(mainPW);

  XtManageChild(mainPW);
  XtVaSetValues(mainWin, XmNworkWindow, mainPW, NULL); 
}



/**************************************************************************** 
*****************************************************************************/
void dragTextMovement(textVScroll, client_data, call_data)
     Widget textVScroll;
     XtPointer client_data;
     XtPointer call_data;
{
    XtUnmanageChild(MainSymForm);
}


/**************************************************************************** 
*****************************************************************************/
void initializeTextSymbols(startSymNum, endSymNum)
     int startSymNum;
     int endSymNum;
{
  int i;
  XmFontList fontList;
  XmString tmpXStr;

  XtVaGetValues(SourceViewer, XmNfontList, &fontList, NULL);
  tmpXStr = XmStringCreateSimple("N");
  TextLineHeight = (int) XmStringHeight(fontList, tmpXStr);
  XmStringFree(tmpXStr);

  for (i=startSymNum; i<=endSymNum; i++) {
    InstrumentationSymbols[i] =
      XtVaCreateManagedWidget("instrumentationSymbol", xmLabelWidgetClass, 
			      MainSymForm, 
			      XmNborderWidth, 0, 
			      XmNwidth, null_width, 
			      XmNheight, null_height,
			      XmNlabelType, XmPIXMAP, 
			      XmNlabelPixmap, NullPix, 
			      XmNy, (lineSelected_height/2)+
			            i*TextLineHeight, 
			      NULL);

  LineSelectedSymbols[i] = 
    XtVaCreateManagedWidget("instrumentationSymbol", xmLabelWidgetClass, 
			    MainSymForm, 
			    XmNborderWidth, 0, 
			    XmNwidth, lineSelected_width, 
			    XmNheight, lineSelected_height, 
			    XmNlabelType, XmPIXMAP, 
			    XmNlabelPixmap, NullPix, 
			    XmNx, 18,
			    XmNy, (lineSelected_height/2)+
			          i*TextLineHeight,
			    NULL);
  }
}



/**************************************************************************** 
*****************************************************************************/
void instrumentLineParts(firstRecord, lineNum)
     INSTREC *firstRecord;
     int lineNum;
{
  INSTREC *tmpPtr;
  XmString tmpXStr;
  int i;

  tmpPtr = firstRecord;

  while ((tmpPtr != NULL) && ((tmpPtr->beginLine)-1 == lineNum)) {
    ListData = (listItemStruct *) realloc(ListData, sizeof(listItemStruct)*
					  (NumSubsetItems+1));

    if (tmpPtr->constructType == OuterLoop) {
      ListData[NumSubsetItems].item = strdup("Outer Loop");
    } else {
      ListData[NumSubsetItems].item = strdup(tmpPtr->invokedFunc);
    }
    ListData[NumSubsetItems].instrumentableStructure = tmpPtr;
    ListData[NumSubsetItems].instrumentationType =
	  tmpPtr->instrumentType;
    NumSubsetItems++;

    tmpPtr = tmpPtr->next;
  }

  for (i=0; i<NumSubsetItems; i++) {
    tmpXStr = XmStringCreateSimple(ListData[i].item);
    XmListAddItemUnselected(SubsetList, tmpXStr, 0);
    XmStringFree(tmpXStr);
  }

  DialogType = multipleOnLine;
  setSubsetDialogValues("Multiple Constructs to Instrument on Line", 
			"Currently Selected Line", 
			"has these constructs");
  popupSubsetDialog();
}



/**************************************************************************** 
*****************************************************************************/
void instrumentSelectedLine(button, instrumentationType, call_data)
     Widget button;
     INSTTYPES instrumentationType;
     XtPointer call_data;
{
  INSTREC *tmpPtr;
  int selectedLine;

  for (selectedLine=0; LineData[selectedLine].startCharPos != 
       LineData[CurrentLineNum].startCharPos; selectedLine++);

  if ((tmpPtr = LineData[CurrentLineNum].firstInstrumentableStructure) == NULL) {
    generateError("Nothing to instrument on this line");
  } else {
      if ((tmpPtr->next) != NULL) {
	if (((tmpPtr->next)->beginLine)-1 == selectedLine) {
	  instrumentLineParts(tmpPtr, selectedLine);
	  updateTextSymbols();
	} else {
            tmpPtr->instrumentType = instrumentationType;
	    LineData[selectedLine].instrumentationType = 
	       instrumentationType;
	    updateTextSymbols();
	  } 
      } else {
	  tmpPtr->instrumentType = instrumentationType;
	    LineData[selectedLine].instrumentationType = 
	      instrumentationType;
	  updateTextSymbols();
	}
      StateChangedSinceSave = True;
    }
}



/****************************************************************************
*****************************************************************************/
void makeMainPane1(mainPW)
     Widget mainPW; 
{
  Widget pane1Form, label;

  pane1Form = 
    XtCreateWidget("pane1Form",xmFormWidgetClass, mainPW, NULL, 0);

  label = 
    XtCreateManagedWidget("label", xmLabelWidgetClass, pane1Form, NULL, 0);

  RoutineList = 
    XmCreateScrolledList(pane1Form, "RoutineList", NULL, 0);

  XtVaSetValues(XtParent(RoutineList), XmNtopWidget, label, NULL);

  XtAddCallback(RoutineList, XmNbrowseSelectionCallback, newRoutineSelected,
		NULL);

  XtManageChild(RoutineList);
  XtManageChild(pane1Form);
}



/****************************************************************************
*****************************************************************************/
void makeMainPane2(mainPW)
     Widget mainPW; 
{
  Widget pane2Form, frame, textVScroll, 
         symbolVScroll, symbolHScroll;

  pane2Form = 
    XtCreateWidget("pane2Form", xmFormWidgetClass, mainPW, NULL, 0);

  FileNameLabel = 
    XtCreateManagedWidget("FileNameLabel", xmLabelWidgetClass, pane2Form, 
			  NULL, 0);

  frame = 
    XtVaCreateWidget("frame",xmFrameWidgetClass, pane2Form, 
		     XmNtopWidget, FileNameLabel, NULL);
  SourceForm = 
    XtCreateWidget("SourceForm", xmFormWidgetClass, frame, NULL, 0);

  SourceViewer = 
    XmCreateScrolledText(SourceForm, "SourceViewer", NULL, 0);

  MainSymForm = 
    XtCreateManagedWidget("MainSymForm", xmFormWidgetClass, SourceForm, 
			  NULL, 0);

  XtVaSetValues(XtParent(SourceViewer), 
		XmNleftWidget, MainSymForm, 
		XmNleftOffset, 5,
		NULL);

  XtVaGetValues(XtParent(SourceViewer), 
		XmNverticalScrollBar, &textVScroll, 
		NULL);

  XtVaSetValues(SourceViewer, XmNshadowThickness, 0, NULL);

  addTextScrollBarCallbacks(textVScroll);

  XtAddCallback(SourceViewer, XmNactivateCallback, textSelectionCallback,
		NULL);

  XtAddEventHandler(SourceViewer, ExposureMask, FALSE, textResizeHandler, 
                    NULL);

  XtManageChild(SourceViewer);
  XtManageChild(SourceForm);  
  XtManageChild(frame);
  XtManageChild(pane2Form);
}



/****************************************************************************
*****************************************************************************/
void makeMainPane3(mainPW)
     Widget mainPW; 
{
  Widget  pane3Form;
  Dimension h;

  pane3Form = 
    XtCreateWidget("pane3Form" , xmFormWidgetClass, mainPW, NULL, 0);

  TraceButton = 
    XtVaCreateManagedWidget("TraceButton", xmPushButtonWidgetClass, pane3Form, 
			    XmNsensitive, False, NULL);

  CountButton = 
    XtVaCreateManagedWidget("CountButton", xmPushButtonWidgetClass, pane3Form, 
			    XmNsensitive, False, NULL);

  ClearButton = 
    XtVaCreateManagedWidget("ClearButton", xmPushButtonWidgetClass, pane3Form, 
			    XmNsensitive, False, NULL);

  XtAddCallback(TraceButton, XmNactivateCallback, instrumentSelectedLine, 
		InstrumentTrace);
  XtAddCallback(CountButton, XmNactivateCallback, instrumentSelectedLine, 
		InstrumentCount);
  XtAddCallback(ClearButton, XmNactivateCallback, instrumentSelectedLine, 
		InstrumentOff);

  XtVaGetValues(TraceButton, XmNheight, &h, NULL);
  XtVaSetValues(pane3Form, XmNpaneMaximum, h, XmNpaneMinimum, h, NULL);

  XtManageChild(pane3Form);
}



/**************************************************************************** 
  This function creates the list of routines found by the parsing code.
  This list contains all routines in the program that are called by other
  routines, that call other routines, and that contain loops, and will be 
  presented to the user for instrumentation selections.
*****************************************************************************/
void makeRoutineList()
{
  INSTREC *tmpPtr = instrumentHead;
  XmString tmpXString;
  int insertionPos = 1;

  XmListDeleteAllItems(RoutineList);
  while (tmpPtr != NULL) {
    tmpXString = XmStringCreateSimple(tmpPtr->invokingFunc);
    if ((! XmListItemExists(RoutineList, tmpXString)) && 
	(tmpPtr->constructType == FunctionCall)) { 
      XmListAddItem(RoutineList, tmpXString, insertionPos);
      insertionPos++;
    }
    XmStringFree(tmpXString);
    tmpXString = XmStringCreateSimple(tmpPtr->invokedFunc);
    if ((! XmListItemExists(RoutineList, tmpXString)) && 
	(tmpPtr->constructType == FunctionCall)) { 
      XmListAddItem(RoutineList, tmpXString, insertionPos);
      insertionPos++;
    }
    tmpPtr = tmpPtr->next;
    XmStringFree(tmpXString);
  }    

  /* select the first position if the list has elements in it */
  if (insertionPos != 1) {
    XmListSelectPos(RoutineList, 1, True);
  }
}



/**************************************************************************** 
*****************************************************************************/
void newRoutineSelected(list, client_data, call_data)
     Widget list;
     XtPointer client_data;
     XmListCallbackStruct *call_data;
{
  XmStringFree(SelectedRoutine);
  SelectedRoutine = XmStringCopy(call_data->item);
}



/**************************************************************************** 
*****************************************************************************/
void textResizeHandler(text, client_data, event)
     Widget text;
     XtPointer client_data;
     XEvent *event;
{
  Widget textVScroll;
  int i, oldSliderSize;
  static int largestSliderSize = 0;

  oldSliderSize = TextSliderSize;

  XtVaGetValues(XtParent(text), XmNverticalScrollBar, &textVScroll, NULL);
  XtVaGetValues(textVScroll, XmNsliderSize, &TextSliderSize, NULL);

  if (TextSliderSize < oldSliderSize) {

    for (i=TextSliderSize; i<oldSliderSize; i++) {
      XtDestroyWidget(InstrumentationSymbols[i]);
      XtDestroyWidget(LineSelectedSymbols[i]);
    }
    largestSliderSize = TextSliderSize;
  }

  if (TextSliderSize > largestSliderSize) {
    initializeTextSymbols(largestSliderSize, TextSliderSize-1);
    largestSliderSize = TextSliderSize;
  }
}



/**************************************************************************** 
*****************************************************************************/
void textSelectionCallback(text, client_data, call_data)
     Widget text;
     XtPointer client_data;
     XtPointer call_data;
{
  XmTextPosition textPos;
  Widget textVScroll;
  char *tmp;
  
  if ( strlen(tmp=XmTextGetString(text)) != 0) {
    textPos = XmTextGetInsertionPosition(text);

    LineData[CurrentLineNum].isLineSelected = False;

    for (CurrentLineNum=0; LineData[CurrentLineNum].startCharPos != textPos; 
	 CurrentLineNum++);

    LineData[CurrentLineNum].isLineSelected = True;
    updateTextSymbols();
  }
}



/**************************************************************************** 
*****************************************************************************/
void textMovement(textVScroll, client_data, call_data)
     Widget textVScroll;
     XtPointer client_data;
     XtPointer call_data;
{
    updateTextSymbols();
}



/**************************************************************************** 
*****************************************************************************/
void updateTextSymbols()
{  
  XmTextPosition topPosition;
  Pixmap pixmap_to_use;  
  int topLineNum, i;
  Widget textVScroll;
  INSTREC *tmpPtr;
  INSTTYPES typeOfFirstInst;
  Boolean mixedInstTypes;


  topPosition = XmTextGetTopCharacter(SourceViewer);

  for (topLineNum=0; LineData[topLineNum].startCharPos < topPosition; 
       topLineNum++);

  for(i=0; i<TextSliderSize; i++) {
    mixedInstTypes = False;
    if (topLineNum+i < NumSourceLines) {
      if (LineData[topLineNum+i].isLineSelected) {
	XtVaSetValues(LineSelectedSymbols[i],
		      XmNlabelPixmap, LineSelectedPix,
		      NULL);
      } else {
	XtVaSetValues(LineSelectedSymbols[i],
		      XmNlabelPixmap, NullPix,
		      NULL);
      }


      tmpPtr = LineData[topLineNum+i].firstInstrumentableStructure;

      if (tmpPtr != NULL) {
	typeOfFirstInst = tmpPtr->instrumentType;
      } else {
	typeOfFirstInst = InstrumentOff;
      }

      while ((tmpPtr != NULL) && ((tmpPtr->beginLine-1) == topLineNum+i)) {
	if (tmpPtr->instrumentType != typeOfFirstInst) {
	  mixedInstTypes = True;
	}
	tmpPtr = tmpPtr->next;
      }

      if (mixedInstTypes) {
	pixmap_to_use = MixedPix;
      } else {
	pixmap_to_use = getPixmapToUse(typeOfFirstInst);
      }

      XtVaSetValues(InstrumentationSymbols[i],
		    XmNlabelPixmap, pixmap_to_use,
		    NULL);
    }
  }
  XtManageChild(MainSymForm);
}

