D			[0-9]
L			[a-zA-Z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%{
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 * Scanner.l:
 *	This is the lex(1) input file for the Pablo instrumenting C
 *	parser.  The lex program produces from this the file lex.yy.c,
 *	containing the code for yylex().  The yylex function is called
 *	by yyparse(), itself produced from the Grammar.y file, whenever
 *	the parser requires another token from the input stream.  The
 *	subsidiary input scanning functions called by yylex which have
 *	special purpose to the C language are found in Parser.c.  The
 *	include file y.tab.h (produced by yacc -d Grammar.y) contains
 *	definitions for each of the token numbers as well as the typedef
 *	for the YYSTYPE union and the declaration of yylval, used to
 *	pass token data from yylex to yyparse.
 */

#include "Parser.h"
#include "y.tab.h"

%}

%%

^"#"			{ scanCPPline();				}

"/*"			{ scanComment();				}

"auto"			{ return makeToken( AUTO		);	}
"break"			{ return makeToken( BREAK		);	}
"case"			{ return makeToken( CASE		);	}
"char"			{ return makeToken( CHAR		);	}
"const"			{ return makeToken( CONST		);	}
"continue"		{ return makeToken( CONTINUE		);	}
"default"		{ return makeToken( DEFAULT		);	}
"do"			{ return makeToken( DO			);	}
"double"		{ return makeToken( DOUBLE		);	}
"..."			{ return makeToken( ELLIPSIS		);	}
"else"			{ return makeToken( ELSE		);	}
"enum"			{ return makeToken( ENUM		);	}
"extern"		{ return makeToken( EXTERN		);	}
"float"			{ return makeToken( FLOAT		);	}
"for"			{ return makeToken( FOR			);	}
"goto"			{ return makeToken( GOTO		);	}
"if"			{ return makeToken( IF			);	}
"int"			{ return makeToken( INT			);	}
"long"			{ return makeToken( LONG		);	}
"register"		{ return makeToken( REGISTER		);	}
"return"		{ return makeToken( RETURN		);	}
"short"			{ return makeToken( SHORT		);	}
"signed"		{ return makeToken( SIGNED		);	}
"sizeof"		{ return makeToken( SIZEOF		);	}
"static"		{ return makeToken( STATIC		);	}
"struct"		{ return makeToken( STRUCT		);	}
"switch"		{ return makeToken( SWITCH		);	}
"typedef"		{ return makeToken( TYPEDEF		);	}
"union"			{ return makeToken( UNION		);	}
"unsigned"		{ return makeToken( UNSIGNED		);	}
"void"			{ return makeToken( VOID		);	}
"volatile"		{ return makeToken( VOLATILE		);	}
"while"			{ return makeToken( WHILE		);	}

{L}({L}|{D})*		{ return makeSymToken( makeSymbol()	);	}

0[xX]{H}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}
0[xX]{H}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}
0{D}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}
0{D}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}
{D}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}
{D}+{IS}?		{ return makeToken( INTEGER_CONSTANT	);	}

'(\\.|[^\\'])+'		{ return makeToken( CHARACTER_CONSTANT	);	}

{D}+{E}{FS}?		{ return makeToken( FLOATING_CONSTANT	);	}
{D}*"."{D}+({E})?{FS}?	{ return makeToken( FLOATING_CONSTANT	);	}
{D}+"."{D}*({E})?{FS}?	{ return makeToken( FLOATING_CONSTANT	);	}

\"(\\.|[^\\"])*\"	{ return makeToken( STRING_LITERAL	);	}

">>="			{ return makeToken( RSHF_ASSIGN		);	}
"<<="			{ return makeToken( LSHF_ASSIGN		);	}
"+="			{ return makeToken( ADD_ASSIGN		);	}
"-="			{ return makeToken( SUB_ASSIGN		);	}
"*="			{ return makeToken( MUL_ASSIGN		);	}
"/="			{ return makeToken( DIV_ASSIGN		);	}
"%="			{ return makeToken( MOD_ASSIGN		);	}
"&="			{ return makeToken( AND_ASSIGN		);	}
"^="			{ return makeToken( XOR_ASSIGN		);	}
"|="			{ return makeToken( OR_ASSIGN		);	}
">>"			{ return makeToken( RSHF_OP		);	}
"<<"			{ return makeToken( LSHF_OP		);	}
"++"			{ return makeToken( INC_OP		);	}
"--"			{ return makeToken( DEC_OP		);	}
"->"			{ return makeToken( PTR_OP		);	}
"&&"			{ return makeToken( AND_OP		);	}
"||"			{ return makeToken( OR_OP		);	}
"<="			{ return makeToken( LE_OP		);	}
">="			{ return makeToken( GE_OP		);	}
"=="			{ return makeToken( EQ_OP		);	}
"!="			{ return makeToken( NE_OP		);	}
";"			{ return makeToken( SM			);	}
"{"			{ return makeToken( LC			);	}
"}"			{ return makeToken( RC			);	}
","			{ return makeToken( CM			);	}
":"			{ return makeToken( COL			);	}
"="			{ return makeToken( ASSIGN_OP		);	}
"("			{ return makeToken( LP			);	}
")"			{ return makeToken( RP			);	}
"["			{ return makeToken( LB			);	}
"]"			{ return makeToken( RB			);	}
"."			{ return makeToken( MEMBER_OP		);	}
"&"			{ return makeToken( AMPERSAND		);	}
"!"			{ return makeToken( NOT_OP		);	}
"~"			{ return makeToken( COMPL_OP		);	}
"-"			{ return makeToken( MINUS_OP		);	}
"+"			{ return makeToken( PLUS_OP		);	}
"*"			{ return makeToken( ASTERISK		);	}
"/"			{ return makeToken( DIV_OP		);	}
"%"			{ return makeToken( MOD_OP		);	}
"<"			{ return makeToken( LT_OP		);	}
">"			{ return makeToken( GT_OP		);	}
"^"			{ return makeToken( XOR_OP		);	}
"|"			{ return makeToken( BITOR_OP		);	}
"?"			{ return makeToken( COND_OP		);	}

[ \t\v\f]		{ inputOffset++;				}
\n			{ inputOffset++; inputLineNumber++;		}
.			{ inputOffset++; /* output warning message? */	}

%%

int
yywrap()
{
	return 1;
}
