/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 * CMMDtrace.h:
 *	This is the include file for applications using the Thinking Machines
 *	CM-5 CMMD system customization interface for the message-passing
 *	extensions to the Pablo trace library.
 */

/* Define the message passing extension trace event IDs.		    */

#define	sendSyncBeginID		900100
#define	receiveSyncBeginID	900101
#define	sendAsyncBeginID	900102
#define	receiveAsyncBeginID	900103
#define	mesgBeginID		900104

#define	sendSyncEndID		900110
#define	receiveSyncEndID	900111
#define	sendAsyncEndID		900112
#define	receiveAsyncEndID	900113
#define	mesgEndID		900114

/* Define the miscellaneous (mesgBeginID/mesgEndID) operation subtypes.	    */

#define	PABLO_CMMD_REDUCE_ADD		0
#define	PABLO_CMMD_REDUCE_MAX		1
#define	PABLO_CMMD_REDUCE_MIN		2
#define	PABLO_CMMD_REDUCE_IOR		3
#define	PABLO_CMMD_REDUCE_XOR		4
#define	PABLO_CMMD_REDUCE_AND		5
#define	PABLO_CMMD_SCAN_ADD		6
#define	PABLO_CMMD_SCAN_MAX		7
#define	PABLO_CMMD_SCAN_MIN		8
#define	PABLO_CMMD_SCAN_IOR		9
#define	PABLO_CMMD_SCAN_XOR		10
#define	PABLO_CMMD_SCAN_AND		11
#define PABLO_CMMD_CONCAT		12

/* Declare functions instrumenting the actual message-passing routines.	     */

extern int	traceSENDSYNC(), traceRECVSYNC();
extern CMMD_mcb	traceSENDASYNC(), traceRECVASYNC();
extern int	traceREDUCEINT(), traceSCANINT();
extern unsigned	traceREDUCEUINT(), traceSCANUINT();
extern double	traceREDUCEFLOAT(), traceREDUCEDOUBLE(),
		traceSCANFLOAT(), traceSCANDOUBLE();
extern void	traceCONCATNODES();

#ifdef MESGTRACE

/* Define macros to call these instrumented routines.			     */

# define	SEND_BLOCK	traceSENDSYNC
# define	RECEIVE_BLOCK	traceRECVSYNC
# define	SEND_ASYNC	traceSENDASYNC
# define	RECEIVE_ASYNC	traceRECVASYNC

# define	REDUCE_INT	traceREDUCEINT
# define	REDUCE_UINT	traceREDUCEUINT
# define	REDUCE_FLOAT	traceREDUCEFLOAT
# define	REDUCE_DOUBLE	traceREDUCEDOUBLE
# define	SCAN_INT	traceSCANINT
# define	SCAN_UINT	traceSCANUINT
# define	SCAN_FLOAT	traceSCANFLOAT
# define	SCAN_DOUBLE	traceSCANDOUBLE
# define	CONCAT_NODES	traceCONCATNODES

#else /* MESGTRACE */

/* Define macros to directly call the actual message-passing routines.	     */

# define	SEND_BLOCK	CMMD_send_block
# define	RECEIVE_BLOCK	CMMD_receive_block
# define	SEND_ASYNC	CMMD_send_async
# define	RECEIVE_ASYNC	CMMD_receive_async

# define	REDUCE_INT	CMMD_reduce_int
# define	REDUCE_UINT	CMMD_reduce_uint
# define	REDUCE_FLOAT	CMMD_reduce_float
# define	REDUCE_DOUBLE	CMMD_reduce_double
# define	SCAN_INT	CMMD_scan_int
# define	SCAN_UINT	CMMD_scan_uint
# define	SCAN_FLOAT	CMMD_scan_float
# define	SCAN_DOUBLE	CMMD_scan_double
# define	CONCAT_NODES	CMMD_concat_with_nodes

#endif /* MESGTRACE */
