/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Tara M. Madhyastha (tara@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/* Define the masks for the message send/receive event families,	    */
/* similarly to FAMILY_EXTERNAL and internal event families in		    */
/* the include file TraceParam.h.					    */

#define creadBeginID    800015
#define creadEndID      800016

#define cwriteBeginID    800017
#define cwriteEndID      800018

#define ireadBeginID    800019
#define ireadEndID      800020

#define iwriteBeginID    800021
#define iwriteEndID      800022

#define setIOModeBeginID    800023
#define ioModeBeginID       800024

#define setIOModeEndID    800036
#define ioModeEndID       800037

#define iowaitBeginID      800025
#define iowaitEndID      800026

#define iodoneBeginID      800027
#define iodoneEndID      800028

#define ireadvBeginID    800038
#define ireadvEndID      800039
#define creadvBeginID    800040
#define creadvEndID      800041

#define iwritevBeginID    800042
#define iwritevEndID      800043
#define cwritevBeginID    800044
#define cwritevEndID      800045

#define forcedFlushBeginID  800046
#define forcedFlushEndID    800047

#define lsizeBeginID        800048
#define lsizeEndID          800049

#define gopenBeginID       800050
#define gopenEndID         800051


#define FAMILY_IOMODE          2900

#define FAMILY_IOWAIT         2300
#define FAMILY_ASYNCH_READ    2400
#define FAMILY_ASYNCH_WRITE   2500
#define FAMILY_FLUSH          2600
#define FAMILY_LSIZE          2700

/* Define data structure types for message send and receive trace records,  */
/* similarly to record data structures in Trace.h			    */

#define IOMODE_NUM_FIELDS  7
struct   ioModeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_IOMODE | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;        /* mode id */
	int     fileID;        /* id of file */
	int     ioMode;        /* io mode */
	double   totalTime;     /* time involved in operation */
};

#define IOWAIT_NUM_FIELDS  7
struct   iowaitRecordData {
        int     packetLength;   /* bytes in packet                          */
        int     packetType;     /* == PKT_DATA                              */
        int     packetTag;      /* == FAMILY_IOWAIT | RECORD_TRACE    */
        int     clockDimension; /* number of ints in a CLOCK                */
        CLOCK   timeStamp;      /* time record generated                    */
        double  seconds;        /* floating-point timestamp                 */
        int     eventID;        /* ID of corresponding event                */
        int     nodeID;         /* Processor id */
        int     ioID;           /* I/O id passed in as argument */
	int     result;         /* value returned, if iodone */
        float   duration;      /* total time required by call */
};

/* FAMILY_ASYNCH_READ family Record Data packet:			    */

#define ASYNCH_READ_NUM_FIELDS   10
struct   asynchReadRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_ASYNCH_READ | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double duration;        /* duration of read                         */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;
	int	filepointer;	/* file id */
	int	numBytes;	/* number bytes read */
	int	numVariables;	/* number variables read */
	int	cause;	        /* some indication of cause */
	int     ioID;           /* IO id */
};


/* FAMILY_WRITE family Record Data packet:			    */
#define ASYNCH_WRITE_NUM_FIELDS   10
struct asynchWriteRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_ASYNCH_WRITE | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double  duration;       /* duration */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* processor number */
	int	filepointer;	/* file id */
	int	numBytes;	/* number bytes written */
	int	numVariables;	/* number variables written */
	int	cause;	        /* some indication of cause */
	int     ioID;           /* IO id */
};


/* FAMILY_FORCEFLUSH family Record Data packet:			    */
#define FORCEFLUSH_NUM_FIELDS        6
struct forcedFlushRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_FORCE_LUSH | RECORD_TRACE      */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		 */
	double  duration;       /* duration */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* processor number */
	int	filepointer;	/* unit number, if specified */
};

/* FAMILY_LSIZE family Record Data packet:      */
#define LSIZE_NUM_FIELDS          9
struct lsizeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_LSIZE_NUM_FIELDS| RECORD_TRACE */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double  duration;       /* duration */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* processor number */
	int	filepointer;	/* unit number, if specified */
	int     offset;         /* offset number bytes */
	int     whence;         /* whence */
	int     size;           /* size */
};

/* these struct definitions are for argument lists, etc. */

struct intelRWBeginArgs {
  long filepointer;      /* file id */
  long numVariables;     /* number variables involved in write */
  long cause;            /* user defined cause */         
};

struct intelAsynchRWEndArgs {
  long ioID;             /* I/O id returned for asynch IO calls */
  int numBytes;          /* number bytes transferred */
};

struct intelLsizeBeginArgs {
  int fileID;            /* file id */
  int offset;
  int whence;
};
