/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 * iPSCtrace.h:
 *	This is the include file for applications using the Intel
 *	iPSC system customization interface for the message-passing
 *	extensions to the Pablo trace library.
 */

/* Define the message passing extension trace event IDs.		    */

#define	csendBeginID		900000
#define	crecvBeginID		900001
#define	isendBeginID		900002
#define	irecvBeginID		900003
#define	mesgBeginID		900004

#define	csendEndID		900010
#define	crecvEndID		900011
#define	isendEndID		900012
#define	irecvEndID		900013
#define	mesgEndID		900014

/* Define the miscellaneous (mesgBeginID/mesgEndID) operation subtypes.	    */

#define	PABLO_IPSC_GCOL		0
#define	PABLO_IPSC_GCOLX	1
#define	PABLO_IPSC_GDHIGH	2
#define	PABLO_IPSC_GDLOW	3
#define	PABLO_IPSC_GDPROD	4
#define	PABLO_IPSC_GDSUM	5
#define	PABLO_IPSC_GIAND	6
#define	PABLO_IPSC_GIHIGH	7
#define	PABLO_IPSC_GILOW	8
#define	PABLO_IPSC_GIOR		9
#define	PABLO_IPSC_GIPROD	10
#define	PABLO_IPSC_GISUM	11
#define	PABLO_IPSC_GIXOR	12
#define	PABLO_IPSC_GLAND	13
#define	PABLO_IPSC_GLOR		14
#define	PABLO_IPSC_GLXOR	15
#define	PABLO_IPSC_GOPF		16
#define	PABLO_IPSC_GSENDX	17
#define	PABLO_IPSC_GSHIGH	18
#define	PABLO_IPSC_GSLOW	19
#define	PABLO_IPSC_GSPROD	20
#define	PABLO_IPSC_GSSUM	21

/* Declare functions instrumenting the actual message-passing routines.	     */

extern long	traceCSEND(), traceCRECV(), traceISEND(), traceIRECV();

extern long	traceGCOL(), traceGCOLX(), traceGDHIGH(), traceGDLOW(),
		traceGDPROD(), traceGDSUM(), traceGIAND(), traceGIHIGH(),
		traceGILOW(), traceGIOR(), traceGIPROD(), traceGISUM(),
		traceGIXOR(), traceGLAND(), traceGLOR(), traceGLXOR(),
		traceGOPF(), traceGSENDX(), traceGSHIGH(), traceGSLOW(),
		traceGSPROD(), traceGSSUM();


#ifdef MESGTRACE

/* Define macros to call these instrumented routines.			     */

# define	CSEND		traceCSEND
# define	CRECV		traceCRECV
# define	ISEND		traceISEND
# define	IRECV		traceIRECV

# define	GCOL		traceGCOL
# define	GCOLX		traceGCOLX
# define	GDHIGH		traceGDHIGH
# define	GDLOW		traceGDLOW
# define	GDPROD		traceGDPROD
# define	GDSUM		traceGDSUM
# define	GIAND		traceGIAND
# define	GIHIGH		traceGIHIGH
# define	GILOW		traceGILOW
# define	GIOR		traceGIOR
# define	GIPROD		traceGIPROD
# define	GISUM		traceGISUM
# define	GIXOR		traceGIXOR
# define	GLAND		traceGLAND
# define	GLOR		traceGLOR
# define	GLXOR		traceGLXOR
# define	GOPF		traceGOPF
# define	GSENDX		traceGSENDX
# define	GSHIGH		traceGSHIGH
# define	GSLOW		traceGSLOW
# define	GSPROD		traceGSPROD
# define	GSSUM		traceGSSUM

#else /* MESGTRACE */

/* Define macros to directly call the actual message-passing routines.	     */

# define	CSEND		csend
# define	CRECV		crecv
# define	ISEND		isend
# define	IRECV		irecv

# define	GCOL		gcol
# define	GCOLX		gcolx
# define	GDHIGH		gdhigh
# define	GDLOW		gdlow
# define	GDPROD		gdprod
# define	GDSUM		gdsum
# define	GIAND		giand
# define	GIHIGH		gihigh
# define	GILOW		gilow
# define	GIOR		gior
# define	GIPROD		giprod
# define	GISUM		gisum
# define	GIXOR		gixor
# define	GLAND		gland
# define	GLOR		glor
# define	GLXOR		glxor
# define	GOPF		gopf
# define	GSENDX		gsendx
# define	GSHIGH		gshigh
# define	GSLOW		gslow
# define	GSPROD		gsprod
# define	GSSUM		gssum

#endif /* MESGTRACE */
