/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 * MesgTrace.h:
 *	This file defines configurable constants and data structure
 *	type definitions for the message-passing extensions to the
 *	Pablo trace capture library, found in the file MesgTrace.c.
 */

/* Define the masks for the message send/receive event families,	    */
/* similarly to FAMILY_EXTERNAL and internal event families in		    */
/* the include file TraceParam.h.					    */

#define FAMILY_SYNCSEND_BEGIN	0200		/* blocking message send    */
#define FAMILY_SYNCRECV_BEGIN	0210		/* blocking message receive */
#define FAMILY_ASYNCSEND_BEGIN	0220		/* async. message send	    */
#define FAMILY_ASYNCRECV_BEGIN	0230		/* async. message receive   */
#define	FAMILY_MESGOP_BEGIN	0300		/* misc. message operation  */

#define FAMILY_SYNCSEND_END	0240		/* blocking message send    */
#define FAMILY_SYNCRECV_END	0250		/* blocking message receive */
#define FAMILY_ASYNCSEND_END	0260		/* async. message send	    */
#define FAMILY_ASYNCRECV_END	0270		/* async. message receive   */
#define	FAMILY_MESGOP_END	0310		/* misc. message operation  */


/* Define data structure types for message send and receive trace records,  */
/* similarly to record data structures in Trace.h			    */

/* FAMILY_SYNCSEND_BEGIN family Record Data packet:			    */

struct syncSendBeginRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_SYNCSEND_BEGIN | RECORD_TRACE  */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	long	messageType;	/* type of message sent			    */

	long	messageLength;	/* size of message sent			    */

	long	destNode;	/* node(s) message sent to		    */

	long	messagePid;	/* process id message sent to		    */
};


/* FAMILY_SYNCRECV_BEGIN family Record Data packet:			    */

struct syncRecvBeginRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_SYNCRECV_BEGIN | RECORD_TRACE  */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	long	messageType;	/* type(s) of message received		    */

	long	messageLength;	/* size of message received		    */
};

/* FAMILY_ASYNCSEND_BEGIN family Record Data packet:			    */

struct asyncSendBeginRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_ASYNCSEND_BEGIN | RECORD_TRACE */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	long	messageType;	/* type of message sent			    */

	long	messageLength;	/* size of message sent			    */

	long	destNode;	/* node(s) message sent to		    */

	long	messagePid;	/* process id message sent to		    */
};


/* FAMILY_ASYNCRECV_BEGIN family Record Data packet:			    */

struct asyncRecvBeginRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_ASYNCRECV_BEGIN | RECORD_TRACE */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	long	messageType;	/* type(s) of message received		    */

	long	messageLength;	/* size of message received		    */
};


/* FAMILY_MESGOP_BEGIN family Record Data packet:			    */

struct mesgOpBeginRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_MESGOP_BEGIN | RECORD_TRACE    */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	int	operationType;	/* type of message-passing operation	    */

};



/* FAMILY_SYNCSEND_END family Record Data packet:			    */

struct syncSendEndRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_SYNCSEND_END | RECORD_TRACE    */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	double	mesgSeconds;	/* floating-point routine duration	    */

	int	durationDim;	/* number of ints in a CLOCK		    */

	CLOCK	mesgDuration;	/* message interface routine duration	    */
};


/* FAMILY_SYNCRECV_END family Record Data packet:			    */

struct syncRecvEndRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	double	mesgSeconds;	/* floating-point routine duration	    */

	int	durationDim;	/* number of ints in a CLOCK		    */

	CLOCK	mesgDuration;	/* message interface routine duration	    */

	int	sourceNode;	/* the sending node number		    */
};

/* FAMILY_ASYNCSEND_END family Record Data packet:			    */

struct asyncSendEndRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_ASYNCSEND_END | RECORD_TRACE   */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	double	mesgSeconds;	/* floating-point routine duration	    */

	int	durationDim;	/* number of ints in a CLOCK		    */

	CLOCK	mesgDuration;	/* message interface routine duration	    */
};


/* FAMILY_ASYNCRECV_END family Record Data packet:			    */

struct asyncRecvEndRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_ASYNCRECV_END | RECORD_TRACE   */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	double	mesgSeconds;	/* floating-point routine duration	    */

	int	durationDim;	/* number of ints in a CLOCK		    */

	CLOCK	mesgDuration;	/* message interface routine duration	    */
};


/* FAMILY_MESGOP_END family Record Data packet:				    */

struct mesgOpEndRecordData {

	int	packetLength;	/* bytes in packet			    */

	int	packetType;	/* == PKT_DATA				    */

	int	packetTag;	/* == FAMILY_MESGOP_END | RECORD_TRACE	    */

	int	clockDimension;	/* number of ints in a CLOCK		    */

	CLOCK	timeStamp;	/* time record generated		    */

	double	seconds;	/* floating-point timestamp		    */

	int	eventID;	/* ID of corresponding event		    */

	int	nodeNumber;	/* occurred on which node		    */

	double	mesgSeconds;	/* floating-point routine duration	    */

	int	durationDim;	/* number of ints in a CLOCK		    */

	CLOCK	mesgDuration;	/* message interface routine duration	    */

	int	operationType;	/* type of message-passing operation	    */

};
