/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *  SystemDepend.h:
 *	This file contains declarations and defined constants for all
 *	the system and machine dependent portions of the portable Pablo
 *	software performance instrumentation library.  This particular
 *	version was developed for the:
 *
 *		Intel iPSC/2 and iPSC/860 hypercubes and Paragon.
 */

#include <stdio.h>

#ifdef __PARAGON__
# include <i860paragon/rpm.h>
# include <nx.h>
#else /* __PARAGON__ */
# include <cube.h>
#endif /* __PARAGON__ */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

extern void	exit();
extern char	*malloc(), *memcpy();

/*
 *	Define the two message types which indicate the origin of the
 *	message to dump trace buffers, whether local (within this node)
 *	or global (from another node).  If the type is global, then
 *	this processor has interrupted its normal flow of execution
 *	because of the completion of a message receive trap.  In such
 *	a case, this node does not need to alert any other nodes of
 *	the need for synchronization and dumping.  If the type is local,
 *	then this node has initiated the call to dump and must send out
 *	a message of the global dump type to the other nodes.  These
 *	specific message type values have been chosen to be above the
 *	range applications are recommended to use, yet below the range
 *	of force message types.  If an application using this software
 *	also uses these message types it will prevent the trace library
 *	and most likely the application from working properly.
 */

#define LOCALDUMP	0x3fffffff	/* Trace buffer dumping forced	    */
#define GLOBALDUMP	0x3ffffffe	/* by local or remote buffer fill   */

#define CLOCKSYNC	0x3ffffffd	/* Clock synchronization message    */
#define CLOCKVALUE	0x3ffffffc	/* Clock value request/response	    */

#define CLOCKPRECISION	{10,0}	/* clock granularity, in ticks of size	    */
				/* returned by TRclockDifference	    */

#define CLOCKRATE	HWHZ	/* Clock ticks per second		    */

#ifdef i860
# define TRgetClock(hwtime)	hwclock((esize_t *)hwtime)
#endif /* i860 */

#define TRgetBuffer(size)	malloc(size)
#define TRbcopy(from,to,length)	memcpy(to,from,length)
#define TRlock()		masktrap(1)
#define TRunlock(restore)	masktrap(restore)
#define TRgetNode()		mynode()

typedef	struct {
	unsigned long	slow;
	long		shigh;
} TR_CLOCK;			/* type returned on clock access	    */

typedef long	TR_LOCK;	/* type returned on lock access		    */ 

int	synchronizeDump();	/* dump synchronization function	    */
int	falseDump();		/* stub synchronization function	    */

#ifdef DEBUG
extern FILE	*debugFile;	/* debug output file pointer		    */
#endif /* DEBUG */
