/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * CString.cc - methods for the character string class.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Base/RCS/CString.C,v 1.17 1994/02/25 04:28:04 aydt Exp $
 */
#include <stdlib.h>
#include <string.h>

#include "CString.h"

/*	
 * We don't use the 'standard' Pablo debugging routines within the Cstring
 * methods.  We want something we can enable and disable on the fly.
 */
int CStringDEBUG = 0;		/* A global variable to enable or disable 
				 * debugging on CString methods.           */

#define CDebug if ( CStringDEBUG ) cout<<form

CString::CString()
{
	stringLength = 0;
	stringValue = new char[1];
	*stringValue = '\0';
	
	CDebug( "%x::CString() stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );
}

CString::CString( const char* stringVal )
{
	stringLength = strlen( stringVal );
	stringValue = new char[stringLength + 1];
	strcpy( stringValue,  stringVal );

	CDebug( "%x::CString( const char *) stringValue=%x ( %s )\n", 
		this, stringVal, stringValue, stringValue );
}

CString::CString( CString& str )
{
	stringLength = str.stringLength;
	stringValue = new char[stringLength + 1];
	strcpy ( stringValue, str.stringValue );

	CDebug( "%x::CString( CString &str ) stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );
}

CString::CString( const CString& str )
{
	stringLength = str.stringLength;
	stringValue = new char[stringLength + 1];
	strcpy ( stringValue, str.stringValue );

	CDebug( "%x::CString( CString &str ) stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );
}

CString::~CString()
{
	CDebug( "%x::~CString( ) stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );
	
	delete[] stringValue;
}

const char* 
CString::getValue() const
{
	return stringValue;
}

CString& 
CString::operator= (const CString& str) 
{
	delete[] stringValue;

	stringLength = str.stringLength;
	stringValue = new char[stringLength + 1];
	strcpy( stringValue, str.stringValue );

	CDebug( "%x::CString op=( const CString & ) stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );

	return *this;
}

CString& 
CString::operator= (const char* charstr)
{
	delete[] stringValue;

	stringLength = strlen( charstr );
	stringValue = new char[stringLength + 1];
	strcpy( stringValue, charstr );

	CDebug( "%x::CString op=( char * ) stringValue=%x ( %s )\n", 
		this, stringValue, stringValue );

	return *this;
}

int 
CString::operator== (const CString& str) const
{
	CDebug( "%x::CString::==(CString& str)\n", this );

	return ( strcmp( stringValue, str.stringValue ) == 0 );
}

int 
CString::operator== (const char *str) const
{
	CDebug( "%x::CString::==(const char *str)\n", this );

	return ( strcmp( stringValue, str ) == 0 );
}

int 
CString::operator <= (const CString& str) const
{
	CDebug( "%x::CString::<=(CString& str)\n", this );

	return ( strcmp( stringValue, str.stringValue ) <= 0 );
}

int 
CString::operator >= (const CString& str) const
{
	CDebug( "%x::CString::>=(CString& str)\n", this );

	return ( strcmp( stringValue, str.stringValue ) >= 0 );
}

int 
CString::operator != (const CString& str) const
{
	CDebug( "%x::CString::!=(CString& str)\n", this );

	return ( strcmp( stringValue, str.stringValue ) != 0 );
}

int 
CString::operator!= (const char *str) const
{
	CDebug( "%x::CString::!=(const char *str)\n", this );

	return ( strcmp( stringValue, str ) != 0 );
}

int 
operator<( const char* charstr, const CString& str ) 
{
    return ( strcmp( charstr, str.stringValue ) < 0 );
}

int 
operator>( const char* charstr, const CString& str )
{
    return ( strcmp( charstr, str.stringValue ) > 0 );
}

int 
operator<=( const char* charstr, const CString& str )
{
    return ( strcmp( charstr, str.stringValue ) <= 0 ); 
}

int 
operator>=( const char* charstr, const CString& str )
{
    return ( strcmp( charstr, str.stringValue ) >= 0 );
}

int 
operator==( const char* charstr, const CString& str ) 
{
    return ( strcmp( charstr, str.stringValue ) == 0 ); 
}

int 
operator!=( const char* charstr, const CString& str )
{
    return ( strcmp( charstr, str.stringValue ) != 0 ); 
}

CString 
CString::operator+ (const CString& str) 
{
 	CDebug( "%x::CString::+(CString& str)\n", this );

	int newLength = stringLength + str.length() + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, stringValue );
	strcat( cs, str.stringValue );

	CString tmp(cs) ;

        CDebug( "%x::CString newStringValue=%x ( %s )\n",
			this, tmp.stringValue, tmp.stringValue );

	delete[] cs;
	return tmp;
}

CString 
CString::operator+ (const char* charstr)
{
 	CDebug( "%x::CString::+(const char * charstr)\n", this );

	int newLength = stringLength + strlen(charstr) + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, stringValue );
	strcat( cs, charstr );

	CString tmp( cs ) ;

        CDebug( "%x::CString newStringValue=%x ( %s )\n",
			this, tmp.stringValue, tmp.stringValue );

	delete[] cs;
	return tmp;
}

CString 
CString::concat( const CString& str )
{
	CDebug( "%x::CString::concat(CString& str)\n", this );

	int newLength = stringLength + str.length() + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, stringValue );
	strcat( cs, str.stringValue );

	CString tmp( cs) ;

	CDebug( "%x::CString newStringValue=%x ( %s )\n", 
		this, tmp.stringValue, tmp.stringValue );

	delete[] cs;
	return tmp;
}

CString 
CString::concat( const char* charstr )
{
	CDebug( "%x::CString::concat(const char * charstr)\n", this );

	int newLength = stringLength + strlen(charstr) + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, stringValue );
	strcat( cs, charstr );

	CString tmp( cs ) ;

	CDebug( "%x::CString newStringValue=%x ( %s )\n", 
		this, tmp.stringValue, tmp.stringValue );

	delete[] cs;
	return tmp;
}

CString 
operator+( const char* charstr, const CString& str )
{
	int newLength = strlen( charstr ) + str.stringLength + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, charstr );
	strcat( cs, str.stringValue );

	CString tmp( cs) ;
	delete[] cs;
	return tmp;
}

CString 
concat( const char* charstr, const CString& str )
{
	int newLength = strlen( charstr ) + str.stringLength + 1;
	char *cs = new char[ newLength ];
	strcpy( cs, charstr );
	strcat( cs, str.stringValue );

	CString tmp( cs) ;
	delete[] cs;
	return tmp;
}

char& 
CString::operator[] (int loc) const
{
	if ((loc < 0) || (loc >= stringLength)) {
	   cerr << "Cstring::operator[] -- index out of bounds. Aborting...\n";
	   abort();
	}

	return stringValue [loc];
}

/*	
 * 	Casting operator
 */
CString::operator const char*() const
{
	return stringValue;
}


void 		/* virtual */
CString::printOn (ostream& os) const
{
	os << stringValue;
}

/*
 * Definition of the static data if not done in a central place
 */
#ifdef CONSTRUCT_NONLOCAL_STATICS
	CString CString::NOMATCH( "_NO_MTCH" );
#endif
