/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * WidgetBase.cc: Baseclass for all widget wrappers
 *	
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Base/RCS/WidgetBase.C,v 1.16 1994/02/25 04:43:28 aydt Exp $
 */
#include <X11/Intrinsic.h>

#include "WidgetBase.h"
#include "XArgs.h"
#include "util.h"

WidgetBase::WidgetBase( WidgetBase *par )
{
    	_setType( "WidgetBase" );
    
    	parent = par;
    	displayParamsSet = 0;
}

WidgetBase::~WidgetBase()
{
    	XtDestroyWidget( widget );
}

/*
 * static functions local to this source file
 */
static String 
getAttachmentAttachmentResource( AttachmentLocation loc )
{
	switch (loc) {
	    case AttachTop:
		return XmNtopAttachment;
	    case AttachRight:
		return XmNrightAttachment;
	    case AttachLeft:
		return XmNleftAttachment;
	    case AttachBottom:
		return XmNbottomAttachment;
	}
	/* Don't expect to get here! */
	cerr << form( "getAttachmentAttachmentResource: Invalid Location %d\n",
		      (int) loc );
	return XmNtopAttachment;
}

static String 
getAttachmentWidgetResource( AttachmentLocation loc )
{
	switch (loc) {
	    case AttachTop:
		return XmNtopWidget;
	    case AttachRight:
		return XmNrightWidget;
	    case AttachLeft:
		return XmNleftWidget;
	    case AttachBottom:
		return XmNbottomWidget;
	}
	/* Don't expect to get here! */
	cerr << form( "getAttachmentWidgetResource:Invalid Location %d\n",
		      (int) loc );
	return XmNtopWidget;
}

static String 
getAttachmentPositionResource( AttachmentLocation loc )
{
	switch (loc) {
	    case AttachTop:
		return XmNtopPosition;
	    case AttachRight:
		return XmNrightPosition;
	    case AttachLeft:
		return XmNleftPosition;
	    case AttachBottom:
		return XmNbottomPosition;
	}
	/* Don't expect to get here! */
	cerr << form( "getAttachmentPositionResource:Invalid Location %d\n",
		      (int) loc );
	return XmNtopPosition;
}

static String 
getAttachmentOffsetResource( AttachmentLocation loc )
{
	switch (loc) {
	    case AttachTop:
		return XmNtopOffset;
	    case AttachRight:
		return XmNrightOffset;
	    case AttachLeft:
		return XmNleftOffset;
	    case AttachBottom:
		return XmNbottomOffset;
	}
	/* Don't expect to get here! */
	cerr << form( "getAttachmentOffsetResource:Invalid Location %d\n",
		      (int) loc );
	return XmNtopOffset;
}

/*
 * protected methods
 */

void 
WidgetBase::_setDisplayParams()
{
	display = XtDisplay( widget );
	screen = XtScreen( widget );
	screenNumber = DefaultScreen( display );
	defaultColormap = DefaultColormap( display, screenNumber );
	displayParamsSet = 1;
};

/*
 * public methods
 */

void 
WidgetBase::addMemberCallback( String name, pCf memberFunction, 
			       Callback *object, XtPointer clientData )
{
    	addCallback( widget, name, memberFunction, object, clientData );
}

void 
WidgetBase::addMemberEventHandler( EventMask mask, Boolean nonmaskable,
			       pEf memberFunction, EventHandler *object, 
			       XtPointer clientData )
{
     	addEventHandler( widget, mask, nonmaskable, memberFunction, object, 
 		         clientData );
}

Pixel 
WidgetBase::allocateColor( const CString& color )
{
	if ( !displayParamsSet ) {
	    _setDisplayParams();
	}
	return AllocateColor( display, defaultColormap, 
			      (char *)color.getValue() );
}

Pixel 
WidgetBase::allocateRGBColor( int red, int green, int blue )
{
	if ( !displayParamsSet ) {
	    _setDisplayParams();
	}
	return AllocateRGBColor( display, defaultColormap, red, green, blue );
}


void 
WidgetBase::attachToWidget( AttachmentLocation attachmentLocation,
		     	    AttachmentType attachmentType,
		            WidgetBase *w )
{
	XArgs xargs;
	String attachResource;

	attachResource = getAttachmentAttachmentResource( attachmentLocation );
	
	if ( getParent()->getType() != "FormWidget" ) {
	    warning( "trying to attach a child of a non-form widget" );
	    return;
	}

	switch (attachmentType) {
	    case AttachNone:
		xargs.addArg( attachResource, XmATTACH_NONE );
		break;

	    case AttachForm:
		xargs.addArg( attachResource, XmATTACH_FORM );
		break;

	    case AttachWidget:
		xargs.addArg( attachResource, XmATTACH_WIDGET );
		if ( w == NULL ) {
			warning( "didn't specify widget in attachWidget" );
			return;
		}
		xargs.addArg( getAttachmentWidgetResource( attachmentLocation ),
			      (XtArgVal) w->getWidget() );
		break;

	    case AttachOppositeWidget:
		xargs.addArg(attachResource, XmATTACH_OPPOSITE_WIDGET);
		if ( w == NULL ) {
			warning( "didn't specify widget in attachWidget\n" );
			return;
		}
		xargs.addArg( getAttachmentWidgetResource( attachmentLocation ),
			      (XtArgVal) w->getWidget() );
		break;

	    case AttachPosition:
		error( "must specifify position with attachPosition" );
		return;
		// break;

	    case AttachSelf:
		xargs.addArg( attachResource, XmATTACH_SELF );
		break;
	}

	if ( getType() == "ListWidget" ) {
	    XtSetValues( XtParent(widget), xargs.getArgs(), xargs.getNArgs() );
	} else {
  	    setArgs( xargs );
	}
}

void 
WidgetBase::attachToWidget( AttachmentLocation attachmentLocation,
			    AttachmentType attachmentType, int position )
{
	XArgs xargs;
	String attachResource;

	attachResource = getAttachmentAttachmentResource(attachmentLocation);
	
	if ( getParent()->getType() != "FormWidget" ) {
	    warning( "trying to attach a child of a non-form widget" );
	    return;
	}

	switch ( attachmentType ) {
	    case AttachPosition:
		xargs.addArg( attachResource, XmATTACH_POSITION );
		xargs.addArg( getAttachmentPositionResource(attachmentLocation),
			      position );
		break;

	    default:
		error( "only attachPosition requires a position" );
		return;
	}

	if ( getType() == "ListWidget" ) {
	    XtSetValues( XtParent(widget), xargs.getArgs(), xargs.getNArgs() );
	} else {
  	    setArgs( xargs );
	}
}

void 
WidgetBase::getArgs( XArgs& xargs )
{
    	XtGetValues( widget, xargs.getArgs(), xargs.getNArgs() );
}

Colormap 
WidgetBase::getDefaultColormap()
{
	if ( !displayParamsSet ) {
	    _setDisplayParams();
	}

	return defaultColormap;
}

Display * 
WidgetBase::getDisplay()
{
	if ( ! displayParamsSet ) {
	    _setDisplayParams();
	}
	return display;
}

void 
WidgetBase::getOrigin( Position *x, Position *y )
{
	XtTranslateCoords( getWidget(), 0, 0, x, y );
}

void 
WidgetBase::getPosition( Position *x, Position *y )
{
	XArgs xargs(2);

	xargs.addArg( XmNx, (XtArgVal) x );
	xargs.addArg( XmNy, (XtArgVal) y );
	getArgs( xargs );
}

Screen * 
WidgetBase::getScreen()
{
	if ( !displayParamsSet ) {
	    _setDisplayParams();
	}
	return screen;
}

int 
WidgetBase::getScreenNumber()
{
	if ( !displayParamsSet ) {
	   _setDisplayParams();
	}
	return screenNumber;
}

void 
WidgetBase::getSize( Dimension *width, Dimension *height )
{
	XArgs xargs(2);

	xargs.addArg( XmNwidth, (XtArgVal) width );
	xargs.addArg( XmNheight, (XtArgVal) height );
	getArgs( xargs );
}

void 
WidgetBase::getValue( String name, XtArgVal value )
{
    	Arg arg[1];

    	XtSetArg( arg[0], name, value );
    	XtGetValues( widget, arg, 1 );
}

void 
WidgetBase::removeMemberCallback( String name, pCf memberFunction, 
			          Callback *object, XtPointer clientData )
{
    	removeCallback( widget, name, memberFunction, object, clientData );
}

void 
WidgetBase::removeMemberEventHandler( EventMask mask, Boolean nonmaskable,
			              pEf memberFunction, EventHandler *object, 
			              XtPointer clientData )
{
    	removeEventHandler( widget, mask, nonmaskable, memberFunction, object, 
		            clientData );
}


void 
WidgetBase::setArgs( XArgs& xargs )
{
	Arg *args;
	int nargs;

	args = xargs.getArgs();
	nargs = xargs.getNArgs();
	XtSetValues( widget, args, nargs );
}

void 
WidgetBase::setPosition( Position x, Position y )
{
	XArgs xargs(2);

	xargs.addArg( XmNx, (XtArgVal) x );
	xargs.addArg( XmNy, (XtArgVal) y );
	setArgs( xargs );
}

void 
WidgetBase::setSensitive( Boolean_ flag )
{
	XtSetSensitive( widget, flag );
}

void 
WidgetBase::setSize( Dimension width, Dimension height )
{
	XArgs xargs(2);

	xargs.addArg( XmNwidth, (XtArgVal) width );
	xargs.addArg( XmNheight, (XtArgVal) height );
	setArgs( xargs );
}

void 
WidgetBase::setUnsensitive()
{
	XtSetSensitive( widget, FALSE_ );
}

void 
WidgetBase::setValue( String name, XtArgVal value )
{ 
	Arg arg[1];

    	XtSetArg( arg[0], name, value );
    	XtSetValues( widget, arg, 1 );
}

void 
WidgetBase::translateCoords( Position fx, Position fy,
			     Position *x, Position *y )
{
	XtTranslateCoords( getWidget(), fx, fy, x, y );
}

