/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * BaseList.cc:
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Misc/RCS/WidgetBasePtrList.C,v 1.14 1994/03/11 01:10:14 aydt Exp aydt $
 */

#include <memory.h>
#include <stdlib.h>


#include "WidgetBasePtrList.h"

static WidgetBase *NullPtr = NULL;

WidgetBasePtrList::WidgetBasePtrList(int initialSize)
{
	list = new WidgetBase * [initialSize];
	nItems = 0;
	nItemsAllocated = initialSize;
	memset(list, 0, nItemsAllocated * sizeof(WidgetBase *));
}

WidgetBasePtrList::~WidgetBasePtrList()
{
	delete [] list;
}

WidgetBasePtrList::WidgetBasePtrList(WidgetBasePtrList &Ptrlist)
{
	int i;
	
	list = new WidgetBase * [Ptrlist.nItemsAllocated];
	nItems = Ptrlist.nItems;
	nItemsAllocated = Ptrlist.nItemsAllocated;

	for (i = 0; i < nItems; i++)
		list[i] = Ptrlist.list[i];
}

WidgetBasePtrList &WidgetBasePtrList::operator=(WidgetBasePtrList &Ptrlist)
{
	int i;

	if (list != NULL)
		delete [] list;
	
	list = new WidgetBase * [Ptrlist.nItemsAllocated];
	nItems = Ptrlist.nItems;
	nItemsAllocated = Ptrlist.nItemsAllocated;


	for (i = 0; i < nItems; i++)
		list[i] = Ptrlist.list[i];

	return *this;
}

int WidgetBasePtrList::addElement(WidgetBase *elt)
{
	int idx;
	
	if (nItems == nItemsAllocated)
	{
		growList(nItems);
	}

	idx = nItems++;

	list[idx] = elt;

	return idx;
}

void WidgetBasePtrList::reset()
{
	nItems = 0;
	memset(list, 0, nItemsAllocated * sizeof(WidgetBase *));
}

int WidgetBasePtrList::computeNewSize(int requestedIndex)
{
	if (requestedIndex < nItemsAllocated)
		return nItemsAllocated * 2;
	else
		return requestedIndex * 2;
}

void WidgetBasePtrList::growList(int n)
{
	resizeListTo(computeNewSize(n));
}

Boolean_ WidgetBasePtrList::resizeListTo(int n)
{
	WidgetBase **oldList;
	
	if (nItemsAllocated > n)
		return TRUE_;

	oldList = list;
	list = new WidgetBase *[n];

	memset(list, 0, n * sizeof(WidgetBase *));

	for (int i = 0; i < nItemsAllocated; i++)
		list[i] = oldList[i];
	
	nItemsAllocated = n;
	delete [] oldList;
	return TRUE_;
}

int 
WidgetBasePtrList::setElement( int n, WidgetBase *elt )
{
	if ( n < 0 ) {
	    cerr << "Ack! index " << n;
	    cerr << " out of bounds in WidgetBasePtrList::setElement(int)\n";
	    return n;
	}

	if (n >= nItemsAllocated)
		growList(n);

	if (n >= nItems)
		nItems = n + 1;
	
	list[n] = elt;
	return n;
}

WidgetBase *WidgetBasePtrList::getElement(int n) const
{
	if (n < 0 || n > nItems) {
	    cerr << "Ack! index " << n;
	    cerr << " out of bounds in WidgetBasePtrList::getElement(int)\n";
	    return NullPtr;
	}

	return list[n];
}

WidgetBase *&WidgetBasePtrList::operator[](int n)
{
	if (n < 0) {
	    cerr << "Ack! index " << n;
	    cerr << " out of bounds in WidgetBasePtrList::getElement(int)\n";
	    return NullPtr;
	}

	if (n >= nItemsAllocated)
		growList(n);
	if (n >= nItems)
		nItems = n + 1;

	return list[n];
}

int WidgetBasePtrList::lookup(WidgetBase *elt) const
{
	int i;

	for (i = 0; i < nItems; i++)
	{
		if (list[i] == elt)
			return i;
	}
	return -1;
}

int WidgetBasePtrList::insertElementAt(int n, WidgetBase *elt)
{
	int i;

	if (n >= nItemsAllocated)
		growList(n);
	if (nItems == nItemsAllocated)
		growList(nItems);

	if (n >=  nItems)
		nItems = n;

	for (i = nItems; i > n; i--)
		list[i] = list[i - 1];
	list[n] = elt;
	nItems++;
	return n;
}


WidgetBase *WidgetBasePtrList::deleteElementAt(int n)
{
	int i;
	WidgetBase *rc;

	if (n >= nItemsAllocated)
		growList(n);

	if (n >=  nItems)
		nItems = n + 1;

	rc = list[n];

	for (i = n; i < nItems - 1; i++)
		list[i] = list[i + 1];
	nItems--;
	list[nItems] = NULL;

	return rc;
}

int WidgetBasePtrList::count() const
{
	return nItems;
}

int WidgetBasePtrList::allocatedSize() const
{
	return nItemsAllocated;
}

int WidgetBasePtrList::isEmpty() const
{
	return nItems == 0;
}

void WidgetBasePtrList::printOn(ostream & os) const
{
	int i;
	
	os << "WidgetBasePtrList: " << count() << " items:\n";
	
	for (i = 0; i < nItems; i++)
	{
		os << form("Item %d: %x\n", i, list[i]);
	}
}
