/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Obj.cc - methods for the base Object class.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Base/RCS/Obj.C,v 1.17 1994/02/25 04:28:08 aydt Exp $
 */
#include <stdarg.h>
#include <stdio.h>

#include "DefaultOutputHandlers.h"
#include "Defines.h"
#include "Obj.h"

#ifdef OBJECT_REGISTRY
#include "ObjectRegistry.h"
#endif

/*
 * Constructor and Destructor
 */
Obj::Obj()
{
	_className = NULLCHARSTRING;

#ifdef OBJECT_REGISTRY	
	if ( OR_registerObjects ) {
		OR_addObj( this );
	}
#endif
}

Obj::Obj( const char *cname )
{
	_className = cname;

#ifdef OBJECT_REGISTRY	
	if ( OR_registerObjects ) {
		OR_addObj( this );
	}
#endif
}

Obj::~Obj()
{

#ifdef OBJECT_REGISTRY	
	if ( OR_registerObjects ) {
		OR_removeObj( this );
	}
#endif

}

/*
 * Public methods
 */
void 				/* virtual */
Obj::abort( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	DefaultAbortHandler( this, buf );
}

void 				/* virtual */
Obj::error( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	DefaultErrorHandler( this, buf );
}

void				/* virtual */
Obj::gentleWarning( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	cerr << form( "Warning (this=%x name=%s): %s\n",
		      this, this->getObjectName(), buf );
}

const char * 			/* virtual */
Obj::getObjectName() const
{
	return _className;
}

void 				/* virtual */
Obj::info( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	DefaultInfoHandler( buf );
}

void 				/* virtual */
Obj::inspect() const
{
     cout << "Insepecting object with default inspector\n";
     cout << form( "Object name: \"%s\"\n", this->getObjectName() );
     cout << "Printed form:\n";
     this->printOn();
     cout << form( "End of object \"%s\"\n", this->getObjectName() );
}

void 
Obj::notImplemented( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	error( "Not Implemented: %s", buf );
}

void 
Obj::shouldNotImplement( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	error( "Should not implement: %s", buf );
}

void 
Obj::subclassResponsibility( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	error( "Subclass Responsibility: %s", buf );
}
	
void 				/* virtual */
Obj::warning( const char *s, ... ) const
{
	static char buf[1024];
	va_list arglist;

	va_start( arglist, s );
	vsprintf( buf, s, arglist );

	DefaultWarningHandler( this, buf );
}

