/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FUConfig/RCS/ParamConfig.C,v 1.18 1994/03/17 17:04:51 aydt Exp $
 *	ParamConfig: Display parameters and let them be modified.
 */
#include <Xm/SeparatoG.h>

#include "ParamConfig.h"
#include "WidgetBasePtrList.h"
#include "FormDialogWidget.h"
#include "FormWidget.h"
#include "ButtonWidget.h"
#include "LabelWidget.h"
#include "LabelledWidget.h"
#include "Pablo.h"
#include "PabloHelpSystem.h"
#include "RowColumnWidget.h"

#include "util.h"

ParamConfig::ParamConfig( WidgetBase *par, FUParams& params,
			  const CString& title, Boolean_ readOnly )
	    :WidgetBase( par ), theParams( params )
{
	/* 
	 * elements is a list of pointers to the Widget Base instances we
	 * create which we need to clean up when we call the destructor.
	 *
	 * vslots is a list of pointers to the value "slot" widget base
	 * instances we create where parameters are changed.  These also
	 * need to be cleaned up later.
	 */
	elements = new WidgetBasePtrList;
	vslots = new WidgetBasePtrList;

	/*
	 * Create our form dialog widget, a rowcolumn to hold the individiual
	 * parameter entries, and the title as the first entry in rowcolumn.
	 */
	dialog = new FormDialogWidget( par, NullArgs, "ParamConfigDialog" );
	elements->addElement( dialog );
	setWidget( dialog->getWidget() );

	WidgetBase *rowcolumn = new RowColumnWidget( dialog, NullArgs,
					             "rowColumn" );
	elements->addElement( rowcolumn );
	rowcolumn->manage();

	WidgetBase *titleLabel = new LabelWidget( rowcolumn, NullArgs, 
						 "title", title );
	elements->addElement( titleLabel );
	titleLabel->manage();

	UtilSetValue( XtParent( getWidget() ), XmNtitle,
	  				       (XtArgVal) title.getValue() );

	/*
	 * Add labels and value slots for each entry in the param list.
	 */
	int i;
	CString label;
	WidgetBase *labelledWidget;
	WidgetBase *valueWidget;

	for ( i = 0; i < theParams.nParams(); i++ ) {
	    BaseFUParamEntry &param = theParams.getEntry( i );
	    label = param.getName() + ": ";
	    labelledWidget = new LabelledWidget( rowcolumn, label );
	    elements->addElement( labelledWidget );

	    valueWidget = param.createWidget( labelledWidget );
	    vslots->addElement( valueWidget );
	    valueWidget->manage();
	}

        /*
         * Create a separator and another form.
         * Inside the form put the Ok, Cancel and Help buttons, with 
	 *  corresponding callbacks for each.
         */
        Widget separator = XtVaCreateManagedWidget( "separator",
                                 xmSeparatorGadgetClass,
                                 dialog->getWidget(),
                                 XmNtopWidget, rowcolumn->getWidget(),
                                 NULL );

        WidgetBase *bottomForm = new FormWidget( dialog, NullArgs,
                                                 "bottomForm" );
        elements->addElement( bottomForm );
        bottomForm->manage();

        XtVaSetValues( bottomForm->getWidget(),
                       XmNtopWidget, separator,
                       NULL );

        WidgetBase *okButton = new ButtonWidget( bottomForm, NullArgs, 
						 "okButton", "OK");
        elements->addElement( okButton );
        okButton->manage();
        okButton->addMemberCallback( XmNactivateCallback, 
			             &Callback::callback1, this );

	if ( ! readOnly ) {
	    WidgetBase *cancelButton = new ButtonWidget( bottomForm, NullArgs,
					     "cancelButton", "Cancel" );
	    cancelButton->manage();
            elements->addElement( cancelButton );
	    cancelButton->addMemberCallback( XmNactivateCallback,
					     &Callback::callback2, this );
	}

        WidgetBase *helpButton = new ButtonWidget( bottomForm, NullArgs, 
					           "helpButton", "Help");
        elements->addElement( helpButton );
        helpButton->manage();
        helpButton->addMemberCallback( XmNactivateCallback, 
			               &Callback::helpCallback, this );

}

ParamConfig::~ParamConfig()
{
	int i;
	int count; 
	WidgetBase *wbp;

	count = elements->count();
	for ( i = 0; i < count; i++ ) {
	    wbp = elements->getElement( i );
	    delete wbp;
	}
	delete elements;

	count = vslots->count();
	for ( i = 0; i < count; i++ ) {
	    wbp = vslots->getElement( i );
	    delete wbp;
	}
	delete vslots;
}

void
ParamConfig::run()
{
	int i;
	WidgetBase *valueWidget;

	/* update the value slots in the display */
	for ( i = 0; i < theParams.nParams(); i++ ) {
	    BaseFUParamEntry &param = theParams.getEntry(i);
	    valueWidget = vslots->getElement( i );
	    param.setWidgetValue( valueWidget );
	}

	/* manage the dialog and run it */
	dialog->manage();
	doneRunning = FALSE_;

	XtAppContext appContext = XtWidgetToApplicationContext( getWidget() );
	XEvent event;

	do {
	    XtAppNextEvent( appContext, &event );
	    XtDispatchEvent( &event );
	} while ( !doneRunning );

	dialog->unmanage();

	if ( successFlag ) {
	    for ( int i = 0; i < theParams.nParams(); i++ ) {
		BaseFUParamEntry &param = theParams.getEntry( i );
		valueWidget = vslots->getElement( i );
	        param.getValueFromWidget( valueWidget );
	    }
	}
}

void 		/* virtual OK callback */
ParamConfig::callback1( Widget /* w */, XtPointer /* clientData */, 
			                XtPointer /* callData */ )
{
	successFlag = TRUE_;
	doneRunning = TRUE_;
}

void 		/* virtual CANCEL callback */
ParamConfig::callback2( Widget /* w */, XtPointer /* clientData */, 
			                XtPointer /* callData */ )
{
	successFlag = FALSE_;
	doneRunning = TRUE_;
}

void 		/* virtual HELP callback */
ParamConfig::helpCallback( Widget /* w */, XtPointer /* clientData */, 
			                   XtPointer /* callData */ )
{
        Pablo::HelpSystem()->giveHelpOn( "ParamConfig" );
}
