/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include "MultivariateFunctionalUnit.h"
#include "Value.h"

#include <Xm/List.h>
#include <Xm/Text.h>
#include <math.h>
#include <stdlib.h>

#define Square(x)       ( (x) * (x) )


MultivariateFunctionalUnit::MultivariateFunctionalUnit()
{
       ppData.isInitialized = False;

       dimension = 0;
       pointCount = 0;
       updateInterval = 1;
       savedValues = NULL;
       preprocessMask = 0;
}

MultivariateFunctionalUnit::~MultivariateFunctionalUnit()
{
}


Widget
MultivariateFunctionalUnit::_createCategoryListArea( Widget parentWidget,
					       CString listAreaPrefix,
					       ConfigPerDimDataStruct *data )
{
       CString currentWidgetName;

       currentWidgetName = listAreaPrefix + "AreaContainer";
       Widget categoryAreaContainer = XtVaCreateManagedWidget(
				          currentWidgetName,
					  xmFormWidgetClass,
					  parentWidget,
					  XmNleftPosition, 0,
					  XmNrightPosition, 1,
					      NULL );
       currentWidgetName = listAreaPrefix + "ListNameLabel";
       Widget categoryListNameLabel = XtVaCreateManagedWidget(
					      currentWidgetName,
					      xmLabelWidgetClass,
					      categoryAreaContainer,
						  NULL );
       currentWidgetName = listAreaPrefix + "ListForm";
       Widget scrolledListForm = XtVaCreateManagedWidget(
					   currentWidgetName,
					   xmFormWidgetClass,
					   categoryAreaContainer,
					   XmNtopWidget, categoryListNameLabel,
					      NULL );
   
       currentWidgetName = listAreaPrefix + "ConfigList";
       data->scrolledLists[0] = XmCreateScrolledList( scrolledListForm,
				       (char *)currentWidgetName.getValue(),
				        NULL, 0 );
       XtManageChild( data->scrolledLists[0] );
       addCallback( data->scrolledLists[0], XmNbrowseSelectionCallback,
		    &Callback::callback4, this, data );

       currentWidgetName = listAreaPrefix + "NameEditArea";
       data->editAreas[0] =
	      XtVaCreateManagedWidget(  currentWidgetName,
		                        xmTextWidgetClass,
				        categoryAreaContainer,
				        XmNtopWidget, scrolledListForm,
					  NULL );
       return( categoryAreaContainer );
}


Widget
MultivariateFunctionalUnit::_createMinValueListArea( Widget parentWidget,
					       CString listAreaPrefix,
					       ConfigPerDimDataStruct *data )
{
       CString currentWidgetName;

       currentWidgetName = listAreaPrefix + "AreaContainer";
       Widget minValueAreaContainer = XtVaCreateManagedWidget(
				          currentWidgetName,
					  xmFormWidgetClass,
					  parentWidget,
					  XmNleftPosition, 1,
					  XmNrightPosition, 2,
					      NULL );
       currentWidgetName = listAreaPrefix + "ListNameLabel";
       Widget minValueListNameLabel = XtVaCreateManagedWidget(
					      currentWidgetName,
					      xmLabelWidgetClass,
					      minValueAreaContainer,
						  NULL );
       currentWidgetName = listAreaPrefix + "ListForm";
       Widget scrolledListForm = XtVaCreateManagedWidget(
					   currentWidgetName,
					   xmFormWidgetClass,
					   minValueAreaContainer,
					   XmNtopWidget, minValueListNameLabel,
					      NULL );

       currentWidgetName = listAreaPrefix + "List";
       data->scrolledLists[1] = XmCreateScrolledList( scrolledListForm,
				       (char *)currentWidgetName.getValue(),
				        NULL, 0 );
       XtManageChild( data->scrolledLists[1] );
       addCallback( data->scrolledLists[1], XmNbrowseSelectionCallback,
		    &Callback::callback4, this, data );

       currentWidgetName = listAreaPrefix + "EditArea";
       data->editAreas[1] =
	          XtVaCreateManagedWidget( currentWidgetName,
		                           xmTextWidgetClass,
				           minValueAreaContainer,
				           XmNtopWidget, scrolledListForm,
					      NULL );

       return( minValueAreaContainer );
}


Widget
MultivariateFunctionalUnit::_createMaxValueListArea( Widget parentWidget,
					       CString listAreaPrefix,
					       ConfigPerDimDataStruct *data )
{
       CString currentWidgetName;

       currentWidgetName = listAreaPrefix + "AreaContainer";
       Widget maxValueAreaContainer = XtVaCreateManagedWidget(
				          currentWidgetName,
					  xmFormWidgetClass,
					  parentWidget,
					  XmNleftPosition, 2,
					  XmNrightPosition, 3,
					      NULL );
       currentWidgetName = listAreaPrefix + "ListNameLabel";
       Widget maxValueListNameLabel = XtVaCreateManagedWidget(
					      currentWidgetName,
					      xmLabelWidgetClass,
					      maxValueAreaContainer,
						  NULL );
       currentWidgetName = listAreaPrefix + "ListForm";
       Widget scrolledListForm = XtVaCreateManagedWidget(
					   currentWidgetName,
					   xmFormWidgetClass,
					   maxValueAreaContainer,
					   XmNtopWidget, maxValueListNameLabel,
					      NULL );

       currentWidgetName = "List";
       data->scrolledLists[2] = XmCreateScrolledList( scrolledListForm,
				       (char *)currentWidgetName.getValue(),
				        NULL, 0 );
       XtManageChild( data->scrolledLists[2] );
       addCallback( data->scrolledLists[2], XmNbrowseSelectionCallback,
		    &Callback::callback4, this, data );

       currentWidgetName = listAreaPrefix + "EditArea";
       data->editAreas[2] =  XtVaCreateManagedWidget( currentWidgetName,
		                           xmTextWidgetClass,
				           maxValueAreaContainer,
				           XmNtopWidget, scrolledListForm,
					      NULL );
       return( maxValueAreaContainer );
}


// These next routines handle data preprocessing
// -------------------------------------------------------------------------

double *
MultivariateFunctionalUnit::_initializePPData( Array *a )
{
       int i;
       static double *dataPoint = new double[dimension];
       Value currentCellValue;

       for (i=0; i<dimension; i++) {
           dataPoint[i] = a->getCellValue(0,i);
	   if ( preprocessMask & PP_EXTRACT_MINMAX ) {
	      ppData.ppMinValues.setElement(i, dataPoint[i] );
              ppData.ppMaxValues.setElement(i, dataPoint[i] );
	   }
	   if ( preprocessMask & PP_NORMALIZE ) {
	      ppData.sumOfX=(double*)XtMalloc(dimension*sizeof(double));
              ppData.partialEX = (double*)XtMalloc(dimension*sizeof(double));
	      ppData.sumOfX[i] = dataPoint[i];     
	      ppData.partialEX[i] = 0.0;
	      ppData.partialCount = 1;
      	   }
       }
       return( dataPoint );
}

double *
MultivariateFunctionalUnit::_addPPData( Array *a, int nPoints )
{
       int i;
       static double *dataPoint = new double[dimension];

       for (i=0; i<dimension; i++) {
           dataPoint[i] = (double)a->getCellValue(nPoints-1,i);
	   if ( preprocessMask & PP_EXTRACT_MINMAX ) {
	      if ( dataPoint[i] < ppData.ppMinValues.getElement(i) ) {
                  ppData.ppMinValues.setElement(i, dataPoint[i] );
              } else if( dataPoint[i] >
	          ppData.ppMaxValues.getElement(i)) {
                  ppData.ppMaxValues.setElement(i, dataPoint[i] );
              }
	   }

	   if ( preprocessMask & PP_NORMALIZE ) {
              ppData.sumOfX[i] += dataPoint[i];
	   }
       }

       if ( preprocessMask & PP_NORMALIZE ) {
          // Compute partial means every 100 points to prevent overflow
          if ( ++ppData.partialCount == 100 ) {
	     for (i=0; i<dimension; i++) {
                 ppData.partialEX[i] += (ppData.sumOfX[i] /
				                 (double)ppData.partialCount);
	         ppData.sumOfX[i] = 0.0;
	     }
	     ppData.partialCount = 0;
          }
       }
       return( dataPoint );
}




void
MultivariateFunctionalUnit::_completePP()
{
       int i,j;

       // Set min/max if necessary
       if ( preprocessMask & PP_EXTRACT_MINMAX ) {
           for (i=0; i<dimension; i++) {
	      double newFUMinValue = ppData.ppMinValues.getElement(i);
              fuMinValues.setElement(i, newFUMinValue );
	      double newFUMaxValue = ppData.ppMaxValues.getElement(i);
	      fuMaxValues.setElement(i, newFUMaxValue );
	   }
       }

       if ( preprocessMask & PP_NORMALIZE ) {
	  // Compute last set of partial results if necessary
          if ( ppData.partialCount > 0 ) {
	     for (i=0; i<dimension; i++) {
                 ppData.partialEX[i] += ( ppData.sumOfX[i] /
					    (float)ppData.partialCount);
	     }
	     ppData.partialCount = 0;
	  }

	  // Compute mean 
	  ppData.mean = (double *)XtMalloc( dimension * sizeof(double) );
	  for (i=0; i<dimension; i++) {
              ppData.mean[i] = ppData.partialEX[i];
// cout << "This mean " << ppData.mean[i] << " \n";
	  }

	  // Compute variance/ standard deviation
	  ppData.variance = (double *)XtMalloc( dimension * sizeof(double) );
	  ppData.stdDev = (double *)XtMalloc( dimension * sizeof(double) );
	  for (i=0; i<dimension; i++) {
              ppData.variance[i] = 0.0;
	  }
	  for (i=0; i < pointCount; i++) {
	      for (j=0; j < dimension; j++) {
	          ppData.variance[j] +=
		         Square(savedValues[i*dimension+j] - ppData.mean[j]);
              } 
	  }
	  for (i=0; i<dimension; i++) {
 	      ppData.variance[i] = (ppData.variance[i] / pointCount);
// cout << "Final variance " << ppData.variance[i] << " \n";
	      ppData.stdDev[i] = sqrt( ppData.variance[i] );
	  }
		  
// cout << "SQRT: Variance " << ppData.variance[i] << " \n";

	  // Normalize data points
	  // Set min/max if necessary
	  if ( preprocessMask & PP_EXTRACT_MINMAX ) {
	     double normMin, normMax;
             for (i=0; i<dimension; i++) {
	         normMin = (ppData.ppMinValues.getElement(i) - ppData.mean[i])/
		                   ppData.stdDev[i];
                 fuMinValues.setElement(i, normMin );
		 normMax = (ppData.ppMaxValues.getElement(i) - ppData.mean[i])/
		                   ppData.stdDev[i];
		 fuMaxValues.setElement(i, normMax );
// printf("Setting m/m to %lf %lf\n", fuMinValues.getElement(i), fuMaxValues.getElement(i) );
	     }
	  }

          for (j=0; j<dimension; j++) {
	      for (i=0; i<pointCount; i++) {
                  savedValues[i*dimension+j] = (savedValues[i*dimension+j] -
                                                        ppData.mean[j] ) / 
					                ppData.stdDev[j];
// cout << "NOW value is " << savedValues[i*dimension+j] << " \n";
              }
	  }
     }
}

// End of preprocessing routines 
// ------------------------------------------------------------------------



Widget
MultivariateFunctionalUnit::_setupPerCategoryDialog(  Widget parentWidget,
					       ConfigPerDimDataStruct *data,
					       CString basePrefix )
{
       CString dialogNamePrefix = basePrefix + "PerDim";
       CString currentWidgetName;
       
       currentWidgetName = dialogNamePrefix + "DialogContainer";
       data->dialog = XmCreateFormDialog( parentWidget,
				         (char *)currentWidgetName.getValue(), 
					 NULL, 0 );
       currentWidgetName = dialogNamePrefix + "ActionArea";
       Widget dialogActionArea = XtVaCreateManagedWidget( currentWidgetName,
						          xmFormWidgetClass,
						          data->dialog,
       						              NULL );
       currentWidgetName = dialogNamePrefix + "ScrollArea";
       Widget dialogScrolledListArea = XtVaCreateManagedWidget(
				         currentWidgetName,
				      	 xmFormWidgetClass,
					 dialogActionArea,
       					     NULL );

       data->numParams = 3;
       data->scrolledLists =(Widget *)XtMalloc(data->numParams*sizeof(Widget));
       data->editAreas = (Widget *)XtMalloc(data->numParams*sizeof(Widget));
       Widget categoryAreaContainer = _createCategoryListArea( 
					      dialogScrolledListArea,
					      basePrefix + "Category",
					      data );
       Widget minValueAreaContainer = _createMinValueListArea( 
                                            dialogScrolledListArea,
					    basePrefix + "MinValue",
					    data );
       Widget maxValueAreaContainer = _createMaxValueListArea(
		                            dialogScrolledListArea,
					    basePrefix + "MaxValue",
					    data );

       currentWidgetName = dialogNamePrefix + "AddChangeButton";
       Widget addChangeAcceptButton = XtVaCreateManagedWidget(
				    currentWidgetName,
			            xmPushButtonWidgetClass,
				    dialogActionArea,
				    XmNtopWidget, dialogScrolledListArea,
	                                     NULL );

       addCallback( addChangeAcceptButton, XmNactivateCallback,
		    &Callback::callback2, this, data );

       Widget paneSeparator = XtVaCreateManagedWidget( 
				       "DialogPaneSeparator",
				       xmSeparatorWidgetClass,
				       data->dialog,
				       XmNtopWidget, dialogActionArea,
					     NULL ); 
       Widget dialogControlArea = XtVaCreateManagedWidget( 
					        "DialogControlArea",
						xmFormWidgetClass,
				                data->dialog,
					        XmNtopWidget, paneSeparator,
						XmNfractionBase, 1,
						      NULL );
       Widget dialogOKButton = XtVaCreateManagedWidget(
					        "DialogOKButton",
					        xmPushButtonWidgetClass,
						dialogControlArea,
        					XmNleftPosition, 0,
						XmNrightPosition, 1,
						    NULL );
       addCallback( dialogOKButton, XmNactivateCallback, &Callback::callback3,
		       this, data );

       // Fix the size of the control button area
/*
       Dimension controlHeight, marginHeight;
       XtVaGetValues( dialogOKButton,
		      XmNheight, &controlHeight,
		         NULL );
       XtVaGetValues( dialogControlArea,
		      XmNmarginHeight, &marginHeight,
		         NULL );
       XtVaSetValues( paneSeparator,
		      XmNbottomOffset, (int)(controlHeight+marginHeight),
		         NULL );
*/
       return(data->dialog);
}


// This is the callback for "Add/Replace" in the category labelling window
void
MultivariateFunctionalUnit::callback2( Widget /* callbackWidget */,
				       XtPointer ptr1, XtPointer /* ptr2 */ )
{
       ConfigPerDimDataStruct *data = (ConfigPerDimDataStruct *)ptr1;

       char *labelText;
       XmString *labelStrings;
       int i;

       for (i=0; i<data->numParams; i++) {
	    /* Extract the new data from the edit area */
            labelText = XmTextGetString( data->editAreas[i] );
	    /* Create a Motif string for this name */
	    labelStrings = (XmString *)XtMalloc( sizeof(XmString) );
	    labelStrings[0] = XmStringCreateSimple( labelText );

	    /* Set the currently active field in the lists to that name */
	    int positionCount, *positionList;
	    XmListGetSelectedPos( data->scrolledLists[i],
			          &positionList, &positionCount );
	    XmListReplaceItemsPos( data->scrolledLists[i],
			           labelStrings, 
			           1, positionList[0] );
	    XmListSelectPos( data->scrolledLists[i],
			     positionList[0]%dimension +1, False );
        }
}



// This is the callback for "OK" in the per-category config window
void
MultivariateFunctionalUnit::callback3( Widget /* callbackWidget */,
			               XtPointer ptr1, XtPointer /* ptr2 */ )
{
        ConfigPerDimDataStruct *data=(ConfigPerDimDataStruct *)ptr1;
	XtUnmanageChild( data->dialog );

	XmString *labelItems, *minItems, *maxItems;

	/* Extract list data */
        XtVaGetValues( data->scrolledLists[0],
		       XmNitems, &labelItems,
		       NULL );
	XtVaGetValues( data->scrolledLists[1],
		       XmNitems, &minItems,
		           NULL );
	XtVaGetValues( data->scrolledLists[2],
		       XmNitems, &maxItems,
		           NULL );
	char *minValueText, *maxValueText;
	int i;
	for (i=0; i<dimension; i++) {
	    fuCategoryLabels.setElement(i, labelItems[i] );
	    XmStringGetLtoR( minItems[i],
			     XmSTRING_DEFAULT_CHARSET,
	                     &minValueText );
	    double minValueDouble = atof(minValueText);
	    fuMinValues.setElement(i, minValueDouble );
	    XmStringGetLtoR( maxItems[i],
			     XmSTRING_DEFAULT_CHARSET,
	                     &maxValueText );
	    double maxValueDouble = atof(maxValueText);
	    fuMaxValues.setElement(i,maxValueDouble);
	}
	fuSubclassProcessPerCategoryCallback();
}


// This is the callback for scrolled list item selection within the
//   category labelling window
void 
MultivariateFunctionalUnit::callback4( Widget callbackWidget,
			               XtPointer ptr1, XtPointer /* ptr2 */)
{
        ConfigPerDimDataStruct *data =(ConfigPerDimDataStruct *)ptr1;
	int *selectedPositions;
	int positionCount;

	int i;

	// Get the new joint list position
	XmListGetSelectedPos(callbackWidget,
			     &selectedPositions,&positionCount);
	// Update all edit areas
	XmString *stringList;
	for (i=0; i<data->numParams; i++) {
	   // Get the string at that dimension index
	   XtVaGetValues( data->scrolledLists[i],
		          XmNitems, &stringList,
		              NULL );
	   // Write the currently-selected string to the edit area
	   char *selectedString;
	   XmStringGetLtoR( stringList[selectedPositions[0]-1],
			    XmSTRING_DEFAULT_CHARSET,
	       		    &selectedString );
	   XmTextSetString( data->editAreas[i], selectedString );
	   XtFree( selectedString );

	   // Update this windows list position to the joint position
	   XmListSelectPos( data->scrolledLists[i], selectedPositions[0],
			    False );
       }
}


void
MultivariateFunctionalUnit::fuSubclassProcessPerCategoryCallback()
{
}





