/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * TrigonometryFU.cc - A polymorophic functional unit for trigonometric
 * 		       functions
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FunctionalUnits/RCS/TrigonometryFU.C,v 1.13 1994/02/25 04:32:27 aydt Exp $
 */

#include "TrigonometryFU.h"
#include "Sine.h"
#include "Cosine.h"
#include "Tangent.h"

#include "FUParams.h"
#include "ParamConfig.h"

TrigonometryFU::TrigonometryFU()
{
	_setClassName( MY_CLASS );
}

TrigonometryFU::~TrigonometryFU()
{
}

void 				/* virtual */
TrigonometryFU::_setOperator( const int opId )
{
	if ( myOperator != NULL ) {
	    delete myOperator;
	}
  	myOperatorNumber = opId;

  	switch ( opId ) {
     	   case SINE:
              myOperator = new Sine;
              break;

     	   case COSINE:
              myOperator = new Cosine;
              break;

     	   case TANGENT:
              myOperator = new Tangent;
              break;

     	   default:
              warning( 
		  "\nOperator id %d does not correspond to any known operation",
	          opId );
              myOperatorNumber = -1;
              break;
  	}

  	if ( myOperatorNumber < 0 ) {
      	   isReady = FALSE_;
  	} else {
           isReady = TRUE_;
  	}
}

void                            /* virtual */
TrigonometryFU::configureOperation()
{
  	int opId = -1;
  	FUParams params;
  	params.addRadioButtonsParam( "Trigonometric Type",
			    BaseFUParamEntry::Integer, 0, UnaryOpNameList );

	ParamConfig pc( Pablo::TopLevel(), params, getName() );
  	BaseFUParamEntry& opEntry = params.getEntry( "Trigonometric Type" );

        if ( myOperatorNumber != -1 ) {
            opEntry.setValue( myOperatorNumber );
        }
        pc.run();

  	if ( opEntry.valueIsValid() ) {
     	   opId = opEntry.getValue().getInteger();
  	} else {
     	   warning( "Operation selection was not valid." );
  	}

  	_setOperator( opId );
}

FunctionalUnit *		/* virtual */
TrigonometryFU::copy()
{
	TrigonometryFU *copy = new TrigonometryFU();
	return copy;
}

void                            /* virtual */
TrigonometryFU::init()
{
        /*
         * Set up operation name list if it hasn't already been done.
         */
        if ( UnaryOpNameList.isEmpty() ) {
	    UnaryOpNameList.addElement( "Sine" );
	    UnaryOpNameList.addElement( "Cosine" );
	    UnaryOpNameList.addElement( "Tangent" );
	}

        /*
         * Call ::init method of base class to initialize other things
         */
        UnaryMathFU::init();
}

/*
 * 	Initialize the static data.   Only executed once.
 */
const char *const TrigonometryFU::MY_CLASS = "TrigonometryFU";
