/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ActionTable.h: Maintains a table of Action Records.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ActionTable.h,v 1.8 1994/02/25 04:28:17 aydt Exp $
 */

#ifndef ActionTable_h
#define ActionTable_h

#include "Obj.h"
#include "ActionRecord.h"

class ActionTable : public Obj {
/*
 *	An ActionTable is a simple array-like list of Action records.
 *      Each InputPipeSocket has an ActionTable associated with it and
 *      entries exist in the table for each record type seen on the InputPipe.
 *      If a record has tag N, it's Action Record will be at index N in the 
 *      ActionTable.  
 */

private:
	static const char *const MY_CLASS;

	ActionRecord* *list;		// The list
	int nItems;		        // Number of slots in list

        /* Method _growList:	        Grow the list to have n+1 elements    */
	void _growList( int n );

public:
	/* Method ActionTable: 		The constructor. Default is to have 2
	*				initial entries.                      */
	ActionTable( int initialSize = 2 );

	/* Method ~ActionTable: 	The destructor.		 	      */
	~ActionTable();

	/* Method loadConfiguration:	Load configuration from filestream    */
	void loadConfiguration( FILE *fp );

	/* Method numEntries:		Return the number of active entries   */
	int numEntries() const;

	/* Method resetAllInvalid:	Set the action type of all table
	*				entries to invalid.                   */
	void resetAllInvalid();

	/* Method saveConfiguration:	Save the table entries to the indicated 
	*				file stream.      		      */
	void saveConfiguration( FILE *fp ) const;

	/* Method operator[]:		Access element using array syntax. If
	*				index is out of range, table is expanded
	*				to include element at given index.    */
 	ActionRecord& operator[]( int index ); 

        /* Method printOn:         	Helper function for output	      */
	virtual void printOn( ostream& strm = cout ) const;
};

inline int
ActionTable::numEntries() const
{
	return nItems;
}


inline ostream& operator<<( ostream& os, ActionTable& actionTable )
{
	actionTable.printOn( os );
	return os;
}

#endif
