/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * BaseFUParamEntry.h: Implements the management of a functional unit parameter
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/BaseFUParamEntry.h,v 1.12 1994/03/08 00:24:14 aydt Exp $	
 */
#ifndef BaseFUParamEntry_h
#define BaseFUParamEntry_h

#include "Obj.h"
#include "CString.h"

#include "FUParamValue.h"

class WidgetBase;

class BaseFUParamEntry : public Obj {
/*
 * BaseFUParamEntry manages a functional unit parameter (for configuration).
 */
private:
	char *_objectName;		// ClassName + name.  Returned by
					// _getObjectName().

public:
	enum FUParamType { Str, Integer, Real, UndefinedType };

#define FUParamTypeIsNumeric(TYPE) (((TYPE) == Real ) || ((TYPE) == Integer))
#define FUParamTypeIsString(TYPE) (TYPE) == Str )

	static BaseFUParamEntry *NullObjPtr;

	/* Method getNull:              Returns pointer to a null object      */
	static BaseFUParamEntry& getNull() { 
		return *NullObjPtr; 
		} ;

protected:
	CString name;
	FUParamType type;
	FUParamValue value;
	Boolean_ validFlag;

	/* Method _setObjectName:       Combines the class name and the name
	*                               to produce an _objectName             */
	void _setObjectName();		

public:
        /* Method BaseFUParamEntry:     The class constructor                 */
	BaseFUParamEntry();

        /* Method BaseFUParamEntry:     The class constructor with
        *                               initialization of name, type
        *                               and value of parameter                */
	BaseFUParamEntry( const CString& name,
			  const FUParamType type,
			  const FUParamValue& value );

        /* Method BaseFUParamEntry:     The class constructor with
        *                               replication of an existing
        *                               parameter                             */
	BaseFUParamEntry( BaseFUParamEntry& ent );

        /* Method ~BaseFUParamEntry:    The class destructor                  */
	~BaseFUParamEntry() ;

	/* Method createWidget:		Create the appropriate type
	*				of widget to accept input -
	*				the argument is the parent.           */
	virtual WidgetBase * createWidget( WidgetBase * ) {
		subclassResponsibility( "BaseFUParamEntry::createWidget" ); 
		return NULL;
		} ;

	/* Method createDisplayWidget:	Create the appropriate type
	*				of widget to display parameters -
	*				the argument is the parent.           */
	virtual WidgetBase * createDisplayWidget( WidgetBase *  ) {
	      	subclassResponsibility( 
			"BaseFUParamEntry::createDisplayWidget" );
		return NULL;
		} ;

        /* Method getName:              Returns the name of the parameter     */
        virtual const CString& getName() const { 
		return name; 
		} ;

	/* Method getObjectName:	Overloads Obj::getObjectName()
	*				to return _objectName	              */
	virtual const char * getObjectName() const;

        /* Method getType:              Returns the type of the parameter     */
        virtual FUParamType getType() const {
		return type; 
		} ;

        /* Method getValue:             Returns the parameter value           */
        virtual const FUParamValue& getValue() const { 
		return value; 
		} ;

        /* Method getValueFromWidget:   Returns the value of the parameter
        *                               widget                                */
	virtual void getValueFromWidget( WidgetBase *w );

	/* Method setValue:		Set the value of the parameter entry  */
	virtual void setValue( const FUParamType newType,
                               const FUParamValue& newValue );

        /* Method setValue:             Assigns a value to the parameter      */
	virtual void setValue( FUParamValue val ) { 
		value = val; 
		} ;
	
        /* Method setWidgetValue:       Sets the value of the parameter
        *                               widget                                */
	virtual void setWidgetValue( WidgetBase *w );

        /* Method valueIsValid:         Indicates if the parameter has been
        *                               assigned a valid value                */
        virtual Boolean_ valueIsValid() const { 
		return validFlag; 
		} ;

        /* Method operator=:            Initialization via copy               */
	BaseFUParamEntry& operator=( const BaseFUParamEntry& ent );

        /* Method operator==:           Tests for parameter equality          */
	int operator==( const BaseFUParamEntry& ent ) const;
};

#endif
