/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Authors: Ruth Aydt (aydt@cs.uiuc.edu)
 * 	 		 Bradley Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * BubbleFU.h: A dynamic matrix display functional unit using bubbles
 *	       to show cell values.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/BubbleFU.h,v 1.19 1994/03/15 16:25:21 aydt Exp $
 */

#ifndef BubbleFU_h
#define BubbleFU_h

#include "CStringObjList.h"
#include "DisplayFunctionalUnit.h"
#include "Value.h"

class BooleanArray;
class BubbleFormWrapper;
class InputPort;
class WidgetBase;

class BubbleFU : public DisplayFunctionalUnit {
/*
*
* A BubbleFU is a functional unit that implements a dynamic array of
* bubbles, where bubble size and color are determined by the input
* data.
*
*/

enum bubblePortTypes { VECTOR_ARRAY = 0,
	         VECTOR_ELEMENT = 1,
                 ARRAY_ELEMENT = 2 };

private:
	static const char *const MY_CLASS;	// My class name
	static CStringObjList	 PortOptionList;

	Boolean_ isConfigured;	// Indicates if configuration has been run
	int	 numRows;	// Number of rows in widget.
	int	 numCols;	// Number of columns in widget.
        double	 minValue;	// The minimum data value we expect
	double	 maxValue;	// The maximum data value we expect
	int	 valueRange;	// The range of values accepted by the widget -
	int	 valueOffset;	// Minimum value in the widget"s value range

	InputPort	   *input;      // The data input port
	InputPort	   *index0;	// For element input
	InputPort	   *index1;
	WidgetBase         *dialog;	// Dialog widget class/parent of bubble
	BubbleFormWrapper  *bubbleForm;	// Our bubble widget c++ class

	Value	     dataValue;		// Data value from current array cell
        Value        inputValue;    	// Data values for entire current array
	Array	     *dataArrayP; 	// Data cells for element input if
					// VECTOR_ELEMENT or ARRAY_ELEMENT
	BooleanArray *cellUsed;   	// Keeps track of updated cells  if
					// VECTOR_ARRAY

	int	 portOption; 		// For selecting input port config

	/* Method _resizeCellUsed:	Resize the BooleanArray cellUsed to the
	*				new dimensions - preserving old cell 
	*				values. Size should only increase.    */
	void _resizeCellUsed( int newDim0, int newDim1 );

	/* Method _resizeDataArrayP:	Resize the Array dataArrayP to the
	*				new dimensions - preserving old cell 
	*				values. Size should only increase.    */
	void _resizeDataArrayP( int newDim0, int newDim1 );

	/* Method _setPortOption:	Sets the port option - called by
	*				configureOperation or loadConfiguration
	*				to verify a 'good' option and create
	*				appropriate port descriptors.         */
	void _setPortOption( int theOption );

public:
	/* Method BubbleFU: 		The BubbleFU constructor	*/
	BubbleFU();

	/* Method ~BubbleFU:		The BubbleFU destructor	 	*/
	~BubbleFU();

	/* Method configure:    	Configure the functional unit	*/
	virtual void configure();

	/* Method configureOperation:	Configure the type of input we
	*				expect for the Bubble.         */
	virtual void configureOperation();

	/* Method copy:			Create a copy of the FU   	*/
	virtual FunctionalUnit * copy();

        /* Method fuCallback:	        Callback handler for the FU     */
        virtual void fuCallback( int iRow, int iCol );
 
	/* Method init:			Initialize the bubble display	*/
	virtual void init();

	/* Method loadConfigFromFile:   Load configuration from a file  */
	virtual Boolean_ loadConfigFromFile( const CString & fileName );

	/* Method ready: 		Returns TRUE_ if the bubble
	*				display is currently executable */
	virtual Boolean_ ready();

	/* Method run:			Execute the bubble display	*/
	virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:     Save configuration to a file   */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;
};

#endif BubbleFU_h
