/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt.cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Callback.h: Class used to manage X callbacks in Pablo.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Callback.h,v 1.9 1994/02/25 04:31:05 aydt Exp $
 */

#ifndef Callback_h
#define Callback_h

#include <X11/Intrinsic.h>

class Callback;
typedef void (Callback::*pCf)( Widget, XtPointer, XtPointer );

class Callback {
/*
*
* The Callback class is a base class for all classes having callbacks - those
* classes will most likely be derived from another class as well.
* It is used to maintain a list of the X Callbacks in the Pablo system.
*
*/
	struct CallbackData {
	    Callback        *_object;           // object instance
            pCf             _memberFunction;    // callback routine in _object
            XtPointer       _clientData;        // client data from _object
	} ;

	class CallbackListEntry {
	    friend class Callback;

	private:
	    Widget          	_w;		// widget
	    String          	_name;		// callback name
	    CallbackData    	cbData;		// registered data
	    CallbackListEntry   *nextEntry;	// pointer to next entry

	    CallbackListEntry()  { nextEntry = NULL; }
        } ;

private:
	CallbackListEntry	*headEntry;
	CallbackListEntry	*tailEntry;

public:
	/* Method staticCallback:	All callbacks directed to this method */
	static void staticCallback( Widget w, XtPointer clientData, 
			            XtPointer callData );

	/* Method Callback:		A Callback constructor with
	*				no initialization		      */
	Callback();

	/* Method ~Callback:		The Callback destructor               */
	virtual ~Callback();

       	/* Method helpCallback:         Virtual method to be overloaded by 
       	*                               derived classes                      */
       	virtual void helpCallback( Widget    /* w 	   */, 
				   XtPointer /* clientData */, 
                                   XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback1:            Virtual method to be overloaded by 
       	*                               derived classes                      */
       	virtual void callback1( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;
 
       	/* Method callback2:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback2( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;
 
       	/* Method callback3:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback3( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback4:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback4( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback5:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback5( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback6:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback6( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback7:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback7( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback8:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback8( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback9:            Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback9( Widget    /* w          */, 
				XtPointer /* clientData */, 
                                XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback10:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback10( Widget    /* w          */, 
			 	 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback11:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback11( Widget    /* w          */, 
				 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback12:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback12( Widget    /* w          */, 
				 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback13:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback13( Widget    /* w          */, 
				 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback14:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback14( Widget    /* w          */, 
				 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

       	/* Method callback15:           Virtual method to be overloaded by 
       	*                               derived classes                       */
       	virtual void callback15( Widget    /* w          */, 
				 XtPointer /* clientData */, 
                                 XtPointer /* callData   */ ) { 
		} ;

	/* Method addCallback:		Method adds a new callback to system  */
	void addCallback( Widget W, String name, pCf memberFunction, 
                          Callback *object, XtPointer  clientData = NULL );

	/* Method removeCallback:	Method removes callback from system   */
	void removeCallback( Widget W, String name, pCf memberFunction, 
                             Callback *object, XtPointer clientData = NULL );

};

#endif Callback_h
