/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 *
*/
/*
 * Cluster.h: An base class for a variety of multivariate clustering algorithms
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Cluster.h,v 1.4 1994/02/25 04:31:33 aydt Exp $
 */

#ifndef Cluster_h
#define Cluster_h

#include "Obj.h"


class Cluster : public Obj {
/* 
 *   Cluster is the topmost class of cluster-analysis routines, with
 *   subclassing done to allow for easy plug-and-play choices of policies
 *   and methods 
 *
*/

private:
protected:
       int dimension;
       double *data;
       int numberOfDataPoints;
       int *clustering;
       int numberOfIntendedClusters, numberOfFoundClusters;

public:
       /* Method Cluster:         The Cluster constructor */
       Cluster();

       /* Method ~Cluster:        The Cluster destructor */
       ~Cluster();

       /* Method cluster:  Perform cluster analysis on the data (storing
	*		   the result internally) 			  */
       virtual void cluster();

       /* Method getCluster:  	Return the set of points located within
 				  a given cluster (in the form of an array
				  of indices into the data array) */
//       virtual int * getCluster( int whichCluster );
								 
       /* Method getClusters:	 Return an integer array giving indices 
	*                        into all data points, one index per array */
       virtual int * getClusters();								
       /* Method getNumberOfClusters:   Return the number of clusters 
	*				found in the analysis */
       int getNumberOfClusters();
								
       /* Method loadDataset: Take in the data to be clustered (in the
	*		       form of an embedded linear array) */
       virtual void loadDataset( double *theData, int theDimension,
				 int numberOfPoints );

       /* Method setNumberOfClusters: Define the number of clusters
	*				to be computed */
       void setNumberOfClusters( int numberOfClusters );
};


/* subclasses define */
inline void
Cluster::cluster()
{
}

inline int *
Cluster::getClusters()
{
     return( clustering );
}

inline int
Cluster::getNumberOfClusters()
{
     return( numberOfFoundClusters );
}


inline void
Cluster::setNumberOfClusters( int numberOfClusters )
{   
     numberOfIntendedClusters = numberOfClusters;
}


#endif

