/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * ConfigBoard.h:   This module implements the configuration binding rule
 *                    "scoreboard"
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ConfigBoard.h,v 1.11 1994/02/25 04:29:14 aydt Exp $	
 */


#ifndef ConfigBoard_h
#define ConfigBoard_h

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>
#include <Xm/TextF.h>

#include "Callback.h"
class CString;
class IntList;
class VoidPtrList;
class DisplayColorTables;
class ConfigBoardDetail;
class InterfaceClass;

class ConfigBoard : public virtual Callback {
/*
* ConfigBoard shows the current binding of functional unit input
* and output ports to data inputs and outputs.
*/

private:
	ConfigBoardDetail *configBoardDetail;
	
        Widget boardShell;
	Widget inputPipeWorkWindow, inputPortWorkWindow,
	       outputPortWorkWindow, outputFieldWorkWindow;
	VoidPtrList *inputPipeGraphics, *inputPortGraphics,
	            *outputPortGraphics, *outputFieldGraphics;
	VoidPtrList *outputFieldContainers;
	VoidPtrList *outputFieldList;

	IntList *inputPipeBindingTable, *inputPortBindingTable,
	        *outputPortBindingTable,
	        *outputFieldToPipeBindingTable, *outputFieldToPortBindingTable;
	IntList *fieldExtractedInputPort, *fieldExtractedOutputField;
	DisplayColorTables *bindingColorTable;
	int currentColorIndex;

	Pixmap pipePixmap, userInputPipePixmap,
	       inputPortPixmap, outputPortPixmap, fieldPixmap;

	/* Method _INTLEN:  Determine how many digits are in an integer */
	int _INTLEN( int value );

	/* Method _addInputPipe:  Create widgets associated with a 
	                            new pipe for this module */
	void _addInputPipe( char *pipeName );

	/* Method _addInputPort:  Create widgets associated with a 
	                           new input port for this module */
	void _addInputPort();

	/* Method _addOutputPort:  Create widgets associated with a 
	                            new output port for this module */
	void _addOutputPort();

	/* Method _centerGraphicAboveLabel:  Perform calculations and
	            effect centering of an icon graphic / label pair */
        void _centerGraphicAboveLabel( Widget graphic, Widget label );

	/* Method _convertFieldNameToNumber:  Get the field number
                    associated with a field name */
	int _convertFieldNameToNumber( const char *fieldName ) const;

	/* Method _convertFieldNumberToName:  Get the field name 
	            associated with a field number */
	const char * _convertFieldNumberToName( int fieldNumber ) const;

	/* Method _convertGraphicToFieldNumber:  Given a widget ID determine
	         which field number that corresponds to */
	int _convertGraphicToFieldNumber( Widget graphicWidget );

	/* Method _deleteOutputFieldBinding:  Deletes the representation
	            of an output field binding, whether it be from an 
		    output port or from an input pipe (can't be from both) */
	void _deleteOutputFieldBinding( int fieldNumber );

	/* Method _getNewBindingColor:  Determine the pixel value of a
	            satisfactory color to be used in representing bindings
		    (may be an existing color) */
	Pixel _getNewBindingColor( int useExistingColor,
				   Widget widgetUsingExistingColor );

	/* Method _setupConfigColormap:  Load colormap entries used
                                           to illustrate bindings */
	void _setupConfigColormap( Widget boardMainWindow );

	/* Method _setupGraphics:   Create pixmaps used in the board */
	void _setupGraphics( Widget boardMainWindow );

	/* Method _setupRecordFieldDatabase:  Load in record and field names
	                   into the scoreboards internal data structures */
	void _setupRecordFieldDatabase();

	/* Method _setupStages:    Create widgets used in the board
	                            stage-by-stage */
	void _setupStages( Widget boardMainWindow );

	/* Method _setupStage:    Create the input pipe stage
	                            portion of the board */
	void _setupStage( Widget boardMainWindow, 
			  Widget& stageChildWorkWindow, 
			  CString childWidgetPrefix );
			  
protected:
        InterfaceClass *interfaceClass;
	int numberInputPipes;
	int numberInputPorts;
	int numberOutputPorts;
	int numberOutputFields;

public:
        /* Method ConfigBoard:      The ConfigBoard constructor */
        ConfigBoard( Display *display, InterfaceClass *interfaceClass );
	
	/* Method ~ConfigBoard:     The ConfigBoard destructor */ 
	~ConfigBoard();

	/* Method addInputPipeOutputFieldBinding:  Add a input pipe->
	                                    output field binding */
	void addInputPipeOutputFieldBinding( int pipeNumber,
					     const char *fieldName );

	/* Method addInputPipePortBinding:  Add a input pipe -> input
	                                    port binding */
	void addInputPipePortBinding( int pipeNumber, int portNumber );
	
	/* Method addOutputPortFieldBinding:  Add a output port -> output
	                                        field binding */
	void addOutputPortFieldBinding( int portNumber, const char *fieldName );

	/* Method addOutputRecordField:  Add a field of the given name to
	                                 the current output record */
	void addOutputRecordField( const char *outputFieldName );

	/* Method callback1:   callback for the detail dialog popup */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method callback2:  Callback for the board dismiss button */
	virtual void callback2( Widget, XtPointer, XtPointer );

	/* Method helpCallback:  Callback for the board help button */
	virtual void helpCallback( Widget, XtPointer, XtPointer );

	/* Method clearAllInputPipePortBindings:  remove all input pipe/
	                         port bindings and clear the color-coding */
	void clearAllInputPipePortBindings();


	/* Method clearAllInputPipeOutputFieldBindings:  remove all
               input pipe/output field bindings and clear the color-coding */
	void clearAllInputPipeOutputFieldBindings();

	/* Method clearAllOutputPortFieldBindings:  remove all output
	       port/output field bindings and clear the color-coding */
	void clearAllOutputPortFieldBindings();

	/* Method clearAllPipePortExtract:  remove all field extractions
               for a given input port */
	void clearAllPipePortExtract();

	/* Method clearAllPipeOutputExtract:  remove all extractions
	       for a given output field */
	void clearAllPipeOutputExtract();

	/* Method clearSingleOutputPortFieldBinding: 	Clear an output port
	*				to output field binding that was
	*				made with addOutputPortFieldBinding */
	void clearSingleOutputPortFieldBinding( int portNumber, 
						const char *fieldName );

	/* Method clearSinglePipePortExtract:  Clear binding for a given
	         port number and record name involved in field-extract */
	void clearSinglePipePortExtract( int portNumber, 
					 const char *recordName );

	/* Method clearSinglePipeOutputExtract:  Clear binding between a
	         given output field name and input pipe record */
	void clearSinglePipeOutputExtract( const char *fieldName, 
					   const char *recordName );

	/* Method deleteOutputRecordField:  Removes an output record field */
	void deleteOutputRecordField( char *fieldName );

	/* Method fieldExtractPipeField:     Register a record field extracted
	*                		    from input pipe to output record 
	*				    field */
	void fieldExtractPipeField( const char *fieldName, 
				    const char *recordName,
				    const char *fieldNameForRecord );

	/* Method fieldExtractPipePort:  Register a record field extracted
	                      from input pipe to input port */
	void fieldExtractPipePort( int portNumber, const char *recordName,
				   const char *fieldName );

        /* Method realize:  make visible the config status board */ 
        void realize();

	/* Method registerInputPipes:  register a sequence of input pipes
	                                 with the board */
	void registerInputPipes();

	/* Method registerInputPorts:  register a sequence of input ports
	                                 with the board */
	void registerInputPorts();

	/* Method registerOutputPorts: register a sequence of output ports
	                                 with the board */
	void registerOutputPorts();
};

#endif
