/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt.cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * EventHandler.h: Class used to manage X event handlers in Pablo.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/EventHandler.h,v 1.7 1994/02/25 04:31:06 aydt Exp $
 */

#ifndef EventHandler_h
#define EventHandler_h

#include <X11/Intrinsic.h>

class EventHandler;
typedef void (EventHandler::*pEf)( Widget, XtPointer, XEvent *, Boolean * );

class EventHandler {
/*
*
* The EventHandler class is a base class for all classes having events - those
* classes will most likely be derived from another class as well.
* It is used to maintain a list of the X EventHandlers in the Pablo system.
*
*/
	struct EventHandlerData {
	    EventHandler    *_object;           // object instance
            pEf             _memberFunction;    // event routine in _object
            XtPointer       _clientData;        // client data from _object
	} ;

	class EventHandlerListEntry {
	    friend class EventHandler;

	private:
	    Widget          	  _w;		// widget
	    EventMask	          _mask;	// event mask 
	    Boolean		  _nonmaskable;	// treatment for nonmask events
	    EventHandlerData   	  ehData;	// registered data
	    EventHandlerListEntry *nextEntry;	// pointer to next entry

	    EventHandlerListEntry()  { nextEntry = NULL; }
        } ;

private:
	EventHandlerListEntry	*headEntry;
	EventHandlerListEntry	*tailEntry;

public:
	/* Method staticEventHandler:	All events directed to this method    */
	static void staticEventHandler( Widget w, XtPointer clientData, 
					XEvent *event, 
					Boolean *contineToDispatch );

	/* Method EventHandler:		A EventHandler constructor with
	*				no initialization		      */
	EventHandler();

	/* Method ~EventHandler		The EventHandler destructor           */
	virtual ~EventHandler();

       	/* Method eventHandler1:        Virtual method to be overloaded by 
       	*                               derived classes                      */
       	virtual void eventHandler1( Widget    /* w                 */, 
				    XtPointer /* clientData        */, 
				    XEvent *  /* event             */,
				    Boolean * /* contineToDispatch */ ) {
		} ;
 
       	/* Method eventHandler2:        Virtual method to be overloaded by 
       	*                               derived classes                      */
       	virtual void eventHandler2( Widget    /* w                 */, 
				    XtPointer /* clientData        */, 
				    XEvent *  /* event             */,
				    Boolean * /* contineToDispatch */ ) {
		} ;
 
       	/* Method eventHandler3:        Virtual method to be overloaded by 
       	*                               derived classes                      */
       	virtual void eventHandler3( Widget    /* w                 */, 
				    XtPointer /* clientData        */, 
				    XEvent *  /* event             */,
				    Boolean * /* contineToDispatch */ ) {
		} ;
 

	/* Method addEventHandler:	Adds a new event handler to system  */
	void addEventHandler( Widget W, EventMask mask, Boolean nonmaskable,
		       	      pEf memberFunction, EventHandler *object, 
			      XtPointer clientData = NULL );

	/* Method removeEventHandler:	Method removes handler from system   */
	void removeEventHandler( Widget W, EventMask mask, Boolean nonmaskable,
			         pEf memberFunction, EventHandler *object, 
			         XtPointer clientData = NULL );

};

#endif EventHandler_h
