/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * FIFOStreamPipe.h: A Stream pipe for FIFO queues.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FIFOStreamPipe.h,v 1.13 1994/02/25 04:30:09 aydt Exp $
 */

#ifndef FIFOStreamPipe_h
#define FIFOStreamPipe_h

#include "StreamPipe.h"
#include "CString.h"

class FIFOStreamPipe : public StreamPipe {
/* 
 *	A FIFOStreamPipe is a stream-based pipe based on a FIFO queue 
 */
private:
	static const char *const MY_CLASS;

	int     peekLength;		// size of "current" peek

	char   *qBuffer;		// our queue buffer
	int	qSize;			// size of buffer
	int	qHead;			// head of the queue
	int	qTail;			// tail of the queue
	int	qBytesInUse;		// queue bytes in use

public:
	/* Method FIFOStreamPipe: 	The FIFOStreamPipe constructor        */
	FIFOStreamPipe( int size, const CString& name );

	/* Method ~FIFOStreamPipe: 	The FIFOStreamPipe destructor         */
	~FIFOStreamPipe();

	/* Method bytesFree: 		Returns the number of bytes that can 
	*				be written 			      */
	virtual int bytesFree() const;

	/* Method bytesReady: 		Returns the number of bytes ready to 
	*				be read 			      */
	virtual int bytesReady() const;

	/* Method createPipeReader:	Returns a BinaryPipeReader.           */
	virtual PipeReader * createPipeReader() const;

	/* Method get: 			Read data from the pipe  	      */
	virtual int get( char *data, int lengthRequested );

	/* Method getInputType:		Always returns BINARY_SDDF	      */
	virtual PabloSddfType getInputType() const {
	     return BINARY_SDDF;
	     } ;

        /* Method getSkippingPeek:      Get data from the pipe, skipping over
        *                               data in the peek buffer.  Also 
	*				clear peek buffer.                    */
        virtual int getSkippingPeek( char *data, int lengthRequested );

	/* Method isEmpty: 		Returns TRUE_ if the pipe is empty    */
	virtual Boolean_ isEmpty() const;

	/* Method isFull: 		Returns TRUE_ if the pipe is full     */
	virtual Boolean_ isFull() const;

	/* Method isInputPipe:		Always returns TRUE_		      */
	virtual Boolean_ isInputPipe() const {
	    return TRUE_;
	    } ;

	/* Method isOutputPipe:		Always returns TRUE_		      */
	virtual Boolean_ isOutputPipe() const {
	    return TRUE_;
	    } ;

	/* Method peek: 		Peek into the pipe                    */
	virtual int peek( char *data, int lengthRequested );

	/* Method put: 			Write data into the pipe              */
	virtual int put( const char *data, int length );

	/* Method printOn: 		Stream output function 		      */
	virtual void printOn( ostream& os ) const;
};

inline ostream & operator<<( ostream& os, FIFOStreamPipe& p )
{
	p.printOn(os);
	return os;
}

#endif
