/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author:	Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * FUParamValue.h: Implements functional unit parameter value management
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FUParamValue.h,v 1.12 1994/03/08 00:47:17 aydt Exp $
 */

#ifndef FUParamValue_h
#define FUParamValue_h

#include "Obj.h"

class FUParamValue : public Obj {
/*
 * FUParamValue manages a single functional unit parameter.
 */

public:
	enum FUParamValueType { Integer, Real, Str, Invalid };

	static char *typeNames[];
	
protected:
	union
	{
		int i;
		double r;
		char *s;
	} value;
	FUParamValueType type;

public:
        /* Method FUParamValue: 	Constructor with value unspecified.   */
	FUParamValue();

        /* Method FUParamValue: 	Constructor for an integer. 	      */
	FUParamValue( int i );

        /* Method FUParamValue: 	Constructor for a real.               */
	FUParamValue( double d );

        /* Method FUParamValue: 	Constructor for a char ptr. Space for 
	*				the string is allocated and a copy is
	*				kept in the object instance.          */
	FUParamValue( char *s );

        /* Method FUParamValue: 	Constructor for a const char ptr. 
	*				Space for the string is allocated and a
	*				copy is kept in the object instance.  */
	FUParamValue( const char *s );

        /* Method FUParamValue: 	The copy constructor. 		      */
	FUParamValue( const FUParamValue& ent );

        /* Method ~FUParamValue: 	The FUParamValue destructor. Frees
	*				space used if this is a Str type.     */
	~FUParamValue();

	/* Method getType:		Returns the type of the parameter.    */
	inline FUParamValueType getType() const { return type; } ;

	/* Method getInteger:		Returns an integer parameter          */
	inline int getInteger() const { return value.i; } ;

	/* Method getReal:		Returns a real parameter.	      */
	inline double getReal() const { return value.r; } ;

	/* Method getString:		Returns a string parameter.	      */
	inline const char * getString() const { return value.s; } ;

	/* Method char*: 		Cast to const char *	              */
	operator const char*() const;

	/* Method int:			Cast to int		              */
	operator int() const;

	/* Method float:		Cast to float			      */
	operator float() const;

	/* Method double:		Cast to double		              */
	operator double() const;

	/* Method operator=:		Parameter value assignment.  If this
	*				is a string, old space is freed and 
	*				new is allocated.                     */
	FUParamValue& operator=( const FUParamValue& val );

	/* Method operator==:		Parameter value equality test.        */
	int operator==( const FUParamValue& val ) const;
};


#endif
